// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;

namespace Azure.ResourceManager.Sql.Models
{
    /// <summary> The UpsertManagedServerOperationStep. </summary>
    public partial class UpsertManagedServerOperationStep
    {
        /// <summary>
        /// Keeps track of any properties unknown to the library.
        /// <para>
        /// To assign an object to the value of this property use <see cref="BinaryData.FromObjectAsJson{T}(T, System.Text.Json.JsonSerializerOptions?)"/>.
        /// </para>
        /// <para>
        /// To assign an already formatted json string to this property use <see cref="BinaryData.FromString(string)"/>.
        /// </para>
        /// <para>
        /// Examples:
        /// <list type="bullet">
        /// <item>
        /// <term>BinaryData.FromObjectAsJson("foo")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("\"foo\"")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromObjectAsJson(new { key = "value" })</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("{\"key\": \"value\"}")</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// </list>
        /// </para>
        /// </summary>
        private IDictionary<string, BinaryData> _serializedAdditionalRawData;

        /// <summary> Initializes a new instance of <see cref="UpsertManagedServerOperationStep"/>. </summary>
        internal UpsertManagedServerOperationStep()
        {
        }

        /// <summary> Initializes a new instance of <see cref="UpsertManagedServerOperationStep"/>. </summary>
        /// <param name="order"></param>
        /// <param name="name"></param>
        /// <param name="status"></param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        internal UpsertManagedServerOperationStep(int? order, string name, UpsertManagedServerOperationStepStatus? status, IDictionary<string, BinaryData> serializedAdditionalRawData)
        {
            Order = order;
            Name = name;
            Status = status;
            _serializedAdditionalRawData = serializedAdditionalRawData;
        }

        /// <summary> Gets the order. </summary>
        [WirePath("order")]
        public int? Order { get; }
        /// <summary> Gets the name. </summary>
        [WirePath("name")]
        public string Name { get; }
        /// <summary> Gets the status. </summary>
        [WirePath("status")]
        public UpsertManagedServerOperationStepStatus? Status { get; }
    }
}
