// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;

namespace Azure.ResourceManager.Sql.Models
{
    /// <summary> Contains the information necessary to perform long term retention backup update operation. </summary>
    public partial class UpdateLongTermRetentionBackupContent
    {
        /// <summary>
        /// Keeps track of any properties unknown to the library.
        /// <para>
        /// To assign an object to the value of this property use <see cref="BinaryData.FromObjectAsJson{T}(T, System.Text.Json.JsonSerializerOptions?)"/>.
        /// </para>
        /// <para>
        /// To assign an already formatted json string to this property use <see cref="BinaryData.FromString(string)"/>.
        /// </para>
        /// <para>
        /// Examples:
        /// <list type="bullet">
        /// <item>
        /// <term>BinaryData.FromObjectAsJson("foo")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("\"foo\"")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromObjectAsJson(new { key = "value" })</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("{\"key\": \"value\"}")</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// </list>
        /// </para>
        /// </summary>
        private IDictionary<string, BinaryData> _serializedAdditionalRawData;

        /// <summary> Initializes a new instance of <see cref="UpdateLongTermRetentionBackupContent"/>. </summary>
        public UpdateLongTermRetentionBackupContent()
        {
        }

        /// <summary> Initializes a new instance of <see cref="UpdateLongTermRetentionBackupContent"/>. </summary>
        /// <param name="requestedBackupStorageRedundancy"> The storage redundancy type of the copied backup. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        internal UpdateLongTermRetentionBackupContent(SqlBackupStorageRedundancy? requestedBackupStorageRedundancy, IDictionary<string, BinaryData> serializedAdditionalRawData)
        {
            RequestedBackupStorageRedundancy = requestedBackupStorageRedundancy;
            _serializedAdditionalRawData = serializedAdditionalRawData;
        }

        /// <summary> The storage redundancy type of the copied backup. </summary>
        [WirePath("properties.requestedBackupStorageRedundancy")]
        public SqlBackupStorageRedundancy? RequestedBackupStorageRedundancy { get; set; }
    }
}
