// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ClientModel.Primitives;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Text.Json;
using Azure.Core;

namespace Azure.ResourceManager.Sql.Models
{
    public partial class TopQueries : IUtf8JsonSerializable, IJsonModel<TopQueries>
    {
        void IUtf8JsonSerializable.Write(Utf8JsonWriter writer) => ((IJsonModel<TopQueries>)this).Write(writer, ModelSerializationExtensions.WireOptions);

        void IJsonModel<TopQueries>.Write(Utf8JsonWriter writer, ModelReaderWriterOptions options)
        {
            writer.WriteStartObject();
            JsonModelWriteCore(writer, options);
            writer.WriteEndObject();
        }

        /// <param name="writer"> The JSON writer. </param>
        /// <param name="options"> The client options for reading and writing models. </param>
        protected virtual void JsonModelWriteCore(Utf8JsonWriter writer, ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<TopQueries>)this).GetFormatFromOptions(options) : options.Format;
            if (format != "J")
            {
                throw new FormatException($"The model {nameof(TopQueries)} does not support writing '{format}' format.");
            }

            if (options.Format != "W" && Optional.IsDefined(NumberOfQueries))
            {
                writer.WritePropertyName("numberOfQueries"u8);
                writer.WriteNumberValue(NumberOfQueries.Value);
            }
            if (options.Format != "W" && Optional.IsDefined(AggregationFunction))
            {
                writer.WritePropertyName("aggregationFunction"u8);
                writer.WriteStringValue(AggregationFunction);
            }
            if (options.Format != "W" && Optional.IsDefined(ObservationMetric))
            {
                writer.WritePropertyName("observationMetric"u8);
                writer.WriteStringValue(ObservationMetric);
            }
            if (options.Format != "W" && Optional.IsDefined(IntervalType))
            {
                writer.WritePropertyName("intervalType"u8);
                writer.WriteStringValue(IntervalType.Value.ToString());
            }
            if (options.Format != "W" && Optional.IsDefined(StartTime))
            {
                writer.WritePropertyName("startTime"u8);
                writer.WriteStringValue(StartTime);
            }
            if (options.Format != "W" && Optional.IsDefined(EndTime))
            {
                writer.WritePropertyName("endTime"u8);
                writer.WriteStringValue(EndTime);
            }
            if (Optional.IsCollectionDefined(Queries))
            {
                writer.WritePropertyName("queries"u8);
                writer.WriteStartArray();
                foreach (var item in Queries)
                {
                    writer.WriteObjectValue(item, options);
                }
                writer.WriteEndArray();
            }
            if (options.Format != "W" && _serializedAdditionalRawData != null)
            {
                foreach (var item in _serializedAdditionalRawData)
                {
                    writer.WritePropertyName(item.Key);
#if NET6_0_OR_GREATER
				writer.WriteRawValue(item.Value);
#else
                    using (JsonDocument document = JsonDocument.Parse(item.Value))
                    {
                        JsonSerializer.Serialize(writer, document.RootElement);
                    }
#endif
                }
            }
        }

        TopQueries IJsonModel<TopQueries>.Create(ref Utf8JsonReader reader, ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<TopQueries>)this).GetFormatFromOptions(options) : options.Format;
            if (format != "J")
            {
                throw new FormatException($"The model {nameof(TopQueries)} does not support reading '{format}' format.");
            }

            using JsonDocument document = JsonDocument.ParseValue(ref reader);
            return DeserializeTopQueries(document.RootElement, options);
        }

        internal static TopQueries DeserializeTopQueries(JsonElement element, ModelReaderWriterOptions options = null)
        {
            options ??= ModelSerializationExtensions.WireOptions;

            if (element.ValueKind == JsonValueKind.Null)
            {
                return null;
            }
            int? numberOfQueries = default;
            string aggregationFunction = default;
            string observationMetric = default;
            QueryTimeGrainType? intervalType = default;
            string startTime = default;
            string endTime = default;
            IReadOnlyList<QueryStatisticsProperties> queries = default;
            IDictionary<string, BinaryData> serializedAdditionalRawData = default;
            Dictionary<string, BinaryData> rawDataDictionary = new Dictionary<string, BinaryData>();
            foreach (var property in element.EnumerateObject())
            {
                if (property.NameEquals("numberOfQueries"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    numberOfQueries = property.Value.GetInt32();
                    continue;
                }
                if (property.NameEquals("aggregationFunction"u8))
                {
                    aggregationFunction = property.Value.GetString();
                    continue;
                }
                if (property.NameEquals("observationMetric"u8))
                {
                    observationMetric = property.Value.GetString();
                    continue;
                }
                if (property.NameEquals("intervalType"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    intervalType = new QueryTimeGrainType(property.Value.GetString());
                    continue;
                }
                if (property.NameEquals("startTime"u8))
                {
                    startTime = property.Value.GetString();
                    continue;
                }
                if (property.NameEquals("endTime"u8))
                {
                    endTime = property.Value.GetString();
                    continue;
                }
                if (property.NameEquals("queries"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    List<QueryStatisticsProperties> array = new List<QueryStatisticsProperties>();
                    foreach (var item in property.Value.EnumerateArray())
                    {
                        array.Add(QueryStatisticsProperties.DeserializeQueryStatisticsProperties(item, options));
                    }
                    queries = array;
                    continue;
                }
                if (options.Format != "W")
                {
                    rawDataDictionary.Add(property.Name, BinaryData.FromString(property.Value.GetRawText()));
                }
            }
            serializedAdditionalRawData = rawDataDictionary;
            return new TopQueries(
                numberOfQueries,
                aggregationFunction,
                observationMetric,
                intervalType,
                startTime,
                endTime,
                queries ?? new ChangeTrackingList<QueryStatisticsProperties>(),
                serializedAdditionalRawData);
        }

        private BinaryData SerializeBicep(ModelReaderWriterOptions options)
        {
            StringBuilder builder = new StringBuilder();
            BicepModelReaderWriterOptions bicepOptions = options as BicepModelReaderWriterOptions;
            IDictionary<string, string> propertyOverrides = null;
            bool hasObjectOverride = bicepOptions != null && bicepOptions.PropertyOverrides.TryGetValue(this, out propertyOverrides);
            bool hasPropertyOverride = false;
            string propertyOverride = null;

            builder.AppendLine("{");

            hasPropertyOverride = hasObjectOverride && propertyOverrides.TryGetValue(nameof(NumberOfQueries), out propertyOverride);
            if (hasPropertyOverride)
            {
                builder.Append("  numberOfQueries: ");
                builder.AppendLine(propertyOverride);
            }
            else
            {
                if (Optional.IsDefined(NumberOfQueries))
                {
                    builder.Append("  numberOfQueries: ");
                    builder.AppendLine($"{NumberOfQueries.Value}");
                }
            }

            hasPropertyOverride = hasObjectOverride && propertyOverrides.TryGetValue(nameof(AggregationFunction), out propertyOverride);
            if (hasPropertyOverride)
            {
                builder.Append("  aggregationFunction: ");
                builder.AppendLine(propertyOverride);
            }
            else
            {
                if (Optional.IsDefined(AggregationFunction))
                {
                    builder.Append("  aggregationFunction: ");
                    if (AggregationFunction.Contains(Environment.NewLine))
                    {
                        builder.AppendLine("'''");
                        builder.AppendLine($"{AggregationFunction}'''");
                    }
                    else
                    {
                        builder.AppendLine($"'{AggregationFunction}'");
                    }
                }
            }

            hasPropertyOverride = hasObjectOverride && propertyOverrides.TryGetValue(nameof(ObservationMetric), out propertyOverride);
            if (hasPropertyOverride)
            {
                builder.Append("  observationMetric: ");
                builder.AppendLine(propertyOverride);
            }
            else
            {
                if (Optional.IsDefined(ObservationMetric))
                {
                    builder.Append("  observationMetric: ");
                    if (ObservationMetric.Contains(Environment.NewLine))
                    {
                        builder.AppendLine("'''");
                        builder.AppendLine($"{ObservationMetric}'''");
                    }
                    else
                    {
                        builder.AppendLine($"'{ObservationMetric}'");
                    }
                }
            }

            hasPropertyOverride = hasObjectOverride && propertyOverrides.TryGetValue(nameof(IntervalType), out propertyOverride);
            if (hasPropertyOverride)
            {
                builder.Append("  intervalType: ");
                builder.AppendLine(propertyOverride);
            }
            else
            {
                if (Optional.IsDefined(IntervalType))
                {
                    builder.Append("  intervalType: ");
                    builder.AppendLine($"'{IntervalType.Value.ToString()}'");
                }
            }

            hasPropertyOverride = hasObjectOverride && propertyOverrides.TryGetValue(nameof(StartTime), out propertyOverride);
            if (hasPropertyOverride)
            {
                builder.Append("  startTime: ");
                builder.AppendLine(propertyOverride);
            }
            else
            {
                if (Optional.IsDefined(StartTime))
                {
                    builder.Append("  startTime: ");
                    if (StartTime.Contains(Environment.NewLine))
                    {
                        builder.AppendLine("'''");
                        builder.AppendLine($"{StartTime}'''");
                    }
                    else
                    {
                        builder.AppendLine($"'{StartTime}'");
                    }
                }
            }

            hasPropertyOverride = hasObjectOverride && propertyOverrides.TryGetValue(nameof(EndTime), out propertyOverride);
            if (hasPropertyOverride)
            {
                builder.Append("  endTime: ");
                builder.AppendLine(propertyOverride);
            }
            else
            {
                if (Optional.IsDefined(EndTime))
                {
                    builder.Append("  endTime: ");
                    if (EndTime.Contains(Environment.NewLine))
                    {
                        builder.AppendLine("'''");
                        builder.AppendLine($"{EndTime}'''");
                    }
                    else
                    {
                        builder.AppendLine($"'{EndTime}'");
                    }
                }
            }

            hasPropertyOverride = hasObjectOverride && propertyOverrides.TryGetValue(nameof(Queries), out propertyOverride);
            if (hasPropertyOverride)
            {
                builder.Append("  queries: ");
                builder.AppendLine(propertyOverride);
            }
            else
            {
                if (Optional.IsCollectionDefined(Queries))
                {
                    if (Queries.Any())
                    {
                        builder.Append("  queries: ");
                        builder.AppendLine("[");
                        foreach (var item in Queries)
                        {
                            BicepSerializationHelpers.AppendChildObject(builder, item, options, 4, true, "  queries: ");
                        }
                        builder.AppendLine("  ]");
                    }
                }
            }

            builder.AppendLine("}");
            return BinaryData.FromString(builder.ToString());
        }

        BinaryData IPersistableModel<TopQueries>.Write(ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<TopQueries>)this).GetFormatFromOptions(options) : options.Format;

            switch (format)
            {
                case "J":
                    return ModelReaderWriter.Write(this, options);
                case "bicep":
                    return SerializeBicep(options);
                default:
                    throw new FormatException($"The model {nameof(TopQueries)} does not support writing '{options.Format}' format.");
            }
        }

        TopQueries IPersistableModel<TopQueries>.Create(BinaryData data, ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<TopQueries>)this).GetFormatFromOptions(options) : options.Format;

            switch (format)
            {
                case "J":
                    {
                        using JsonDocument document = JsonDocument.Parse(data);
                        return DeserializeTopQueries(document.RootElement, options);
                    }
                default:
                    throw new FormatException($"The model {nameof(TopQueries)} does not support reading '{options.Format}' format.");
            }
        }

        string IPersistableModel<TopQueries>.GetFormatFromOptions(ModelReaderWriterOptions options) => "J";
    }
}
