// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.Sql.Models
{
    /// <summary> Type of the sync agent linked database. </summary>
    public readonly partial struct SyncMemberDbType : IEquatable<SyncMemberDbType>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="SyncMemberDbType"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public SyncMemberDbType(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string AzureSqlDatabaseValue = "AzureSqlDatabase";
        private const string SqlServerDatabaseValue = "SqlServerDatabase";

        /// <summary> AzureSqlDatabase. </summary>
        public static SyncMemberDbType AzureSqlDatabase { get; } = new SyncMemberDbType(AzureSqlDatabaseValue);
        /// <summary> SqlServerDatabase. </summary>
        public static SyncMemberDbType SqlServerDatabase { get; } = new SyncMemberDbType(SqlServerDatabaseValue);
        /// <summary> Determines if two <see cref="SyncMemberDbType"/> values are the same. </summary>
        public static bool operator ==(SyncMemberDbType left, SyncMemberDbType right) => left.Equals(right);
        /// <summary> Determines if two <see cref="SyncMemberDbType"/> values are not the same. </summary>
        public static bool operator !=(SyncMemberDbType left, SyncMemberDbType right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="SyncMemberDbType"/>. </summary>
        public static implicit operator SyncMemberDbType(string value) => new SyncMemberDbType(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is SyncMemberDbType other && Equals(other);
        /// <inheritdoc />
        public bool Equals(SyncMemberDbType other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
