// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.Sql.Models
{
    /// <summary> State of the sync agent. </summary>
    public readonly partial struct SyncAgentState : IEquatable<SyncAgentState>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="SyncAgentState"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public SyncAgentState(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string OnlineValue = "Online";
        private const string OfflineValue = "Offline";
        private const string NeverConnectedValue = "NeverConnected";

        /// <summary> Online. </summary>
        public static SyncAgentState Online { get; } = new SyncAgentState(OnlineValue);
        /// <summary> Offline. </summary>
        public static SyncAgentState Offline { get; } = new SyncAgentState(OfflineValue);
        /// <summary> NeverConnected. </summary>
        public static SyncAgentState NeverConnected { get; } = new SyncAgentState(NeverConnectedValue);
        /// <summary> Determines if two <see cref="SyncAgentState"/> values are the same. </summary>
        public static bool operator ==(SyncAgentState left, SyncAgentState right) => left.Equals(right);
        /// <summary> Determines if two <see cref="SyncAgentState"/> values are not the same. </summary>
        public static bool operator !=(SyncAgentState left, SyncAgentState right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="SyncAgentState"/>. </summary>
        public static implicit operator SyncAgentState(string value) => new SyncAgentState(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is SyncAgentState other && Equals(other);
        /// <inheritdoc />
        public bool Equals(SyncAgentState other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
