// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;
using Azure.Core;
using Azure.ResourceManager.Models;

namespace Azure.ResourceManager.Sql.Models
{
    /// <summary> An Azure SQL Database sync agent linked database. </summary>
    public partial class SyncAgentLinkedDatabase : ResourceData
    {
        /// <summary>
        /// Keeps track of any properties unknown to the library.
        /// <para>
        /// To assign an object to the value of this property use <see cref="BinaryData.FromObjectAsJson{T}(T, System.Text.Json.JsonSerializerOptions?)"/>.
        /// </para>
        /// <para>
        /// To assign an already formatted json string to this property use <see cref="BinaryData.FromString(string)"/>.
        /// </para>
        /// <para>
        /// Examples:
        /// <list type="bullet">
        /// <item>
        /// <term>BinaryData.FromObjectAsJson("foo")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("\"foo\"")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromObjectAsJson(new { key = "value" })</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("{\"key\": \"value\"}")</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// </list>
        /// </para>
        /// </summary>
        private IDictionary<string, BinaryData> _serializedAdditionalRawData;

        /// <summary> Initializes a new instance of <see cref="SyncAgentLinkedDatabase"/>. </summary>
        public SyncAgentLinkedDatabase()
        {
        }

        /// <summary> Initializes a new instance of <see cref="SyncAgentLinkedDatabase"/>. </summary>
        /// <param name="id"> The id. </param>
        /// <param name="name"> The name. </param>
        /// <param name="resourceType"> The resourceType. </param>
        /// <param name="systemData"> The systemData. </param>
        /// <param name="databaseType"> Type of the sync agent linked database. </param>
        /// <param name="databaseId"> Id of the sync agent linked database. </param>
        /// <param name="description"> Description of the sync agent linked database. </param>
        /// <param name="serverName"> Server name of the sync agent linked database. </param>
        /// <param name="databaseName"> Database name of the sync agent linked database. </param>
        /// <param name="userName"> User name of the sync agent linked database. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        internal SyncAgentLinkedDatabase(ResourceIdentifier id, string name, ResourceType resourceType, SystemData systemData, SyncMemberDbType? databaseType, Guid? databaseId, string description, string serverName, string databaseName, string userName, IDictionary<string, BinaryData> serializedAdditionalRawData) : base(id, name, resourceType, systemData)
        {
            DatabaseType = databaseType;
            DatabaseId = databaseId;
            Description = description;
            ServerName = serverName;
            DatabaseName = databaseName;
            UserName = userName;
            _serializedAdditionalRawData = serializedAdditionalRawData;
        }

        /// <summary> Type of the sync agent linked database. </summary>
        [WirePath("properties.databaseType")]
        public SyncMemberDbType? DatabaseType { get; }
        /// <summary> Id of the sync agent linked database. </summary>
        [WirePath("properties.databaseId")]
        public Guid? DatabaseId { get; }
        /// <summary> Description of the sync agent linked database. </summary>
        [WirePath("properties.description")]
        public string Description { get; }
        /// <summary> Server name of the sync agent linked database. </summary>
        [WirePath("properties.serverName")]
        public string ServerName { get; }
        /// <summary> Database name of the sync agent linked database. </summary>
        [WirePath("properties.databaseName")]
        public string DatabaseName { get; }
        /// <summary> User name of the sync agent linked database. </summary>
        [WirePath("properties.userName")]
        public string UserName { get; }
    }
}
