// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.Sql.Models
{
    /// <summary> SQL Vulnerability Assessment rule type. </summary>
    public readonly partial struct SqlVulnerabilityAssessmentRuleType : IEquatable<SqlVulnerabilityAssessmentRuleType>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="SqlVulnerabilityAssessmentRuleType"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public SqlVulnerabilityAssessmentRuleType(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string BinaryValue = "Binary";
        private const string BaselineExpectedValue = "BaselineExpected";
        private const string PositiveListValue = "PositiveList";
        private const string NegativeListValue = "NegativeList";

        /// <summary> Binary. </summary>
        public static SqlVulnerabilityAssessmentRuleType Binary { get; } = new SqlVulnerabilityAssessmentRuleType(BinaryValue);
        /// <summary> BaselineExpected. </summary>
        public static SqlVulnerabilityAssessmentRuleType BaselineExpected { get; } = new SqlVulnerabilityAssessmentRuleType(BaselineExpectedValue);
        /// <summary> PositiveList. </summary>
        public static SqlVulnerabilityAssessmentRuleType PositiveList { get; } = new SqlVulnerabilityAssessmentRuleType(PositiveListValue);
        /// <summary> NegativeList. </summary>
        public static SqlVulnerabilityAssessmentRuleType NegativeList { get; } = new SqlVulnerabilityAssessmentRuleType(NegativeListValue);
        /// <summary> Determines if two <see cref="SqlVulnerabilityAssessmentRuleType"/> values are the same. </summary>
        public static bool operator ==(SqlVulnerabilityAssessmentRuleType left, SqlVulnerabilityAssessmentRuleType right) => left.Equals(right);
        /// <summary> Determines if two <see cref="SqlVulnerabilityAssessmentRuleType"/> values are not the same. </summary>
        public static bool operator !=(SqlVulnerabilityAssessmentRuleType left, SqlVulnerabilityAssessmentRuleType right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="SqlVulnerabilityAssessmentRuleType"/>. </summary>
        public static implicit operator SqlVulnerabilityAssessmentRuleType(string value) => new SqlVulnerabilityAssessmentRuleType(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is SqlVulnerabilityAssessmentRuleType other && Equals(other);
        /// <inheritdoc />
        public bool Equals(SqlVulnerabilityAssessmentRuleType other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
