// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.Sql.Models
{
    /// <summary> SQL Vulnerability Assessment baseline status. </summary>
    public readonly partial struct SqlVulnerabilityAssessmentRuleStatus : IEquatable<SqlVulnerabilityAssessmentRuleStatus>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="SqlVulnerabilityAssessmentRuleStatus"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public SqlVulnerabilityAssessmentRuleStatus(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string NonFindingValue = "NonFinding";
        private const string FindingValue = "Finding";
        private const string InternalErrorValue = "InternalError";

        /// <summary> NonFinding. </summary>
        public static SqlVulnerabilityAssessmentRuleStatus NonFinding { get; } = new SqlVulnerabilityAssessmentRuleStatus(NonFindingValue);
        /// <summary> Finding. </summary>
        public static SqlVulnerabilityAssessmentRuleStatus Finding { get; } = new SqlVulnerabilityAssessmentRuleStatus(FindingValue);
        /// <summary> InternalError. </summary>
        public static SqlVulnerabilityAssessmentRuleStatus InternalError { get; } = new SqlVulnerabilityAssessmentRuleStatus(InternalErrorValue);
        /// <summary> Determines if two <see cref="SqlVulnerabilityAssessmentRuleStatus"/> values are the same. </summary>
        public static bool operator ==(SqlVulnerabilityAssessmentRuleStatus left, SqlVulnerabilityAssessmentRuleStatus right) => left.Equals(right);
        /// <summary> Determines if two <see cref="SqlVulnerabilityAssessmentRuleStatus"/> values are not the same. </summary>
        public static bool operator !=(SqlVulnerabilityAssessmentRuleStatus left, SqlVulnerabilityAssessmentRuleStatus right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="SqlVulnerabilityAssessmentRuleStatus"/>. </summary>
        public static implicit operator SqlVulnerabilityAssessmentRuleStatus(string value) => new SqlVulnerabilityAssessmentRuleStatus(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is SqlVulnerabilityAssessmentRuleStatus other && Equals(other);
        /// <inheritdoc />
        public bool Equals(SqlVulnerabilityAssessmentRuleStatus other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
