// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.Sql.Models
{
    /// <summary> SQL Vulnerability Assessment rule severity. </summary>
    public readonly partial struct SqlVulnerabilityAssessmentRuleSeverity : IEquatable<SqlVulnerabilityAssessmentRuleSeverity>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="SqlVulnerabilityAssessmentRuleSeverity"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public SqlVulnerabilityAssessmentRuleSeverity(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string HighValue = "High";
        private const string MediumValue = "Medium";
        private const string LowValue = "Low";
        private const string InformationalValue = "Informational";
        private const string ObsoleteValue = "Obsolete";

        /// <summary> High. </summary>
        public static SqlVulnerabilityAssessmentRuleSeverity High { get; } = new SqlVulnerabilityAssessmentRuleSeverity(HighValue);
        /// <summary> Medium. </summary>
        public static SqlVulnerabilityAssessmentRuleSeverity Medium { get; } = new SqlVulnerabilityAssessmentRuleSeverity(MediumValue);
        /// <summary> Low. </summary>
        public static SqlVulnerabilityAssessmentRuleSeverity Low { get; } = new SqlVulnerabilityAssessmentRuleSeverity(LowValue);
        /// <summary> Informational. </summary>
        public static SqlVulnerabilityAssessmentRuleSeverity Informational { get; } = new SqlVulnerabilityAssessmentRuleSeverity(InformationalValue);
        /// <summary> Obsolete. </summary>
        public static SqlVulnerabilityAssessmentRuleSeverity Obsolete { get; } = new SqlVulnerabilityAssessmentRuleSeverity(ObsoleteValue);
        /// <summary> Determines if two <see cref="SqlVulnerabilityAssessmentRuleSeverity"/> values are the same. </summary>
        public static bool operator ==(SqlVulnerabilityAssessmentRuleSeverity left, SqlVulnerabilityAssessmentRuleSeverity right) => left.Equals(right);
        /// <summary> Determines if two <see cref="SqlVulnerabilityAssessmentRuleSeverity"/> values are not the same. </summary>
        public static bool operator !=(SqlVulnerabilityAssessmentRuleSeverity left, SqlVulnerabilityAssessmentRuleSeverity right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="SqlVulnerabilityAssessmentRuleSeverity"/>. </summary>
        public static implicit operator SqlVulnerabilityAssessmentRuleSeverity(string value) => new SqlVulnerabilityAssessmentRuleSeverity(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is SqlVulnerabilityAssessmentRuleSeverity other && Equals(other);
        /// <inheritdoc />
        public bool Equals(SqlVulnerabilityAssessmentRuleSeverity other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
