// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;

namespace Azure.ResourceManager.Sql.Models
{
    /// <summary> SQL Vulnerability Assessment rule metadata details. </summary>
    public partial class SqlVulnerabilityAssessmentRuleMetadata
    {
        /// <summary>
        /// Keeps track of any properties unknown to the library.
        /// <para>
        /// To assign an object to the value of this property use <see cref="BinaryData.FromObjectAsJson{T}(T, System.Text.Json.JsonSerializerOptions?)"/>.
        /// </para>
        /// <para>
        /// To assign an already formatted json string to this property use <see cref="BinaryData.FromString(string)"/>.
        /// </para>
        /// <para>
        /// Examples:
        /// <list type="bullet">
        /// <item>
        /// <term>BinaryData.FromObjectAsJson("foo")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("\"foo\"")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromObjectAsJson(new { key = "value" })</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("{\"key\": \"value\"}")</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// </list>
        /// </para>
        /// </summary>
        private IDictionary<string, BinaryData> _serializedAdditionalRawData;

        /// <summary> Initializes a new instance of <see cref="SqlVulnerabilityAssessmentRuleMetadata"/>. </summary>
        internal SqlVulnerabilityAssessmentRuleMetadata()
        {
            BenchmarkReferences = new ChangeTrackingList<SqlVulnerabilityAssessmentBenchmarkReference>();
        }

        /// <summary> Initializes a new instance of <see cref="SqlVulnerabilityAssessmentRuleMetadata"/>. </summary>
        /// <param name="ruleId"> SQL Vulnerability Assessment rule Id. </param>
        /// <param name="severity"> SQL Vulnerability Assessment rule severity. </param>
        /// <param name="category"> SQL Vulnerability Assessment rule category. </param>
        /// <param name="ruleType"> SQL Vulnerability Assessment rule type. </param>
        /// <param name="title"> SQL Vulnerability Assessment rule title. </param>
        /// <param name="description"> SQL Vulnerability Assessment rule description. </param>
        /// <param name="rationale"> SQL Vulnerability Assessment rule rationale. </param>
        /// <param name="queryCheck"> SQL Vulnerability Assessment rule query details. </param>
        /// <param name="benchmarkReferences"> SQL Vulnerability Assessment benchmark references. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        internal SqlVulnerabilityAssessmentRuleMetadata(string ruleId, SqlVulnerabilityAssessmentRuleSeverity? severity, string category, SqlVulnerabilityAssessmentRuleType? ruleType, string title, string description, string rationale, SqlVulnerabilityAssessmentQueryCheck queryCheck, IReadOnlyList<SqlVulnerabilityAssessmentBenchmarkReference> benchmarkReferences, IDictionary<string, BinaryData> serializedAdditionalRawData)
        {
            RuleId = ruleId;
            Severity = severity;
            Category = category;
            RuleType = ruleType;
            Title = title;
            Description = description;
            Rationale = rationale;
            QueryCheck = queryCheck;
            BenchmarkReferences = benchmarkReferences;
            _serializedAdditionalRawData = serializedAdditionalRawData;
        }

        /// <summary> SQL Vulnerability Assessment rule Id. </summary>
        [WirePath("ruleId")]
        public string RuleId { get; }
        /// <summary> SQL Vulnerability Assessment rule severity. </summary>
        [WirePath("severity")]
        public SqlVulnerabilityAssessmentRuleSeverity? Severity { get; }
        /// <summary> SQL Vulnerability Assessment rule category. </summary>
        [WirePath("category")]
        public string Category { get; }
        /// <summary> SQL Vulnerability Assessment rule type. </summary>
        [WirePath("ruleType")]
        public SqlVulnerabilityAssessmentRuleType? RuleType { get; }
        /// <summary> SQL Vulnerability Assessment rule title. </summary>
        [WirePath("title")]
        public string Title { get; }
        /// <summary> SQL Vulnerability Assessment rule description. </summary>
        [WirePath("description")]
        public string Description { get; }
        /// <summary> SQL Vulnerability Assessment rule rationale. </summary>
        [WirePath("rationale")]
        public string Rationale { get; }
        /// <summary> SQL Vulnerability Assessment rule query details. </summary>
        [WirePath("queryCheck")]
        public SqlVulnerabilityAssessmentQueryCheck QueryCheck { get; }
        /// <summary> SQL Vulnerability Assessment benchmark references. </summary>
        [WirePath("benchmarkReferences")]
        public IReadOnlyList<SqlVulnerabilityAssessmentBenchmarkReference> BenchmarkReferences { get; }
    }
}
