// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;

namespace Azure.ResourceManager.Sql.Models
{
    /// <summary> SQL Vulnerability Assessment query check object. </summary>
    public partial class SqlVulnerabilityAssessmentQueryCheck
    {
        /// <summary>
        /// Keeps track of any properties unknown to the library.
        /// <para>
        /// To assign an object to the value of this property use <see cref="BinaryData.FromObjectAsJson{T}(T, System.Text.Json.JsonSerializerOptions?)"/>.
        /// </para>
        /// <para>
        /// To assign an already formatted json string to this property use <see cref="BinaryData.FromString(string)"/>.
        /// </para>
        /// <para>
        /// Examples:
        /// <list type="bullet">
        /// <item>
        /// <term>BinaryData.FromObjectAsJson("foo")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("\"foo\"")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromObjectAsJson(new { key = "value" })</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("{\"key\": \"value\"}")</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// </list>
        /// </para>
        /// </summary>
        private IDictionary<string, BinaryData> _serializedAdditionalRawData;

        /// <summary> Initializes a new instance of <see cref="SqlVulnerabilityAssessmentQueryCheck"/>. </summary>
        internal SqlVulnerabilityAssessmentQueryCheck()
        {
            ExpectedResult = new ChangeTrackingList<IList<string>>();
            ColumnNames = new ChangeTrackingList<string>();
        }

        /// <summary> Initializes a new instance of <see cref="SqlVulnerabilityAssessmentQueryCheck"/>. </summary>
        /// <param name="query"> SQL Vulnerability Assessment rule query. </param>
        /// <param name="expectedResult"> SQL Vulnerability Assessment query expected result. </param>
        /// <param name="columnNames"> SQL Vulnerability Assessment column names of query expected result. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        internal SqlVulnerabilityAssessmentQueryCheck(string query, IReadOnlyList<IList<string>> expectedResult, IReadOnlyList<string> columnNames, IDictionary<string, BinaryData> serializedAdditionalRawData)
        {
            Query = query;
            ExpectedResult = expectedResult;
            ColumnNames = columnNames;
            _serializedAdditionalRawData = serializedAdditionalRawData;
        }

        /// <summary> SQL Vulnerability Assessment rule query. </summary>
        [WirePath("query")]
        public string Query { get; }
        /// <summary> SQL Vulnerability Assessment query expected result. </summary>
        [WirePath("expectedResult")]
        public IReadOnlyList<IList<string>> ExpectedResult { get; }
        /// <summary> SQL Vulnerability Assessment column names of query expected result. </summary>
        [WirePath("columnNames")]
        public IReadOnlyList<string> ColumnNames { get; }
    }
}
