// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.Sql.Models
{
    /// <summary> The SqlVulnerabilityAssessmentBaselineName. </summary>
    public readonly partial struct SqlVulnerabilityAssessmentBaselineName : IEquatable<SqlVulnerabilityAssessmentBaselineName>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="SqlVulnerabilityAssessmentBaselineName"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public SqlVulnerabilityAssessmentBaselineName(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string DefaultValue = "default";

        /// <summary> default. </summary>
        public static SqlVulnerabilityAssessmentBaselineName Default { get; } = new SqlVulnerabilityAssessmentBaselineName(DefaultValue);
        /// <summary> Determines if two <see cref="SqlVulnerabilityAssessmentBaselineName"/> values are the same. </summary>
        public static bool operator ==(SqlVulnerabilityAssessmentBaselineName left, SqlVulnerabilityAssessmentBaselineName right) => left.Equals(right);
        /// <summary> Determines if two <see cref="SqlVulnerabilityAssessmentBaselineName"/> values are not the same. </summary>
        public static bool operator !=(SqlVulnerabilityAssessmentBaselineName left, SqlVulnerabilityAssessmentBaselineName right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="SqlVulnerabilityAssessmentBaselineName"/>. </summary>
        public static implicit operator SqlVulnerabilityAssessmentBaselineName(string value) => new SqlVulnerabilityAssessmentBaselineName(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is SqlVulnerabilityAssessmentBaselineName other && Equals(other);
        /// <inheritdoc />
        public bool Equals(SqlVulnerabilityAssessmentBaselineName other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
