// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;
using Azure.Core;
using Azure.ResourceManager.Models;

namespace Azure.ResourceManager.Sql.Models
{
    /// <summary> A database sql vulnerability assessment rule baseline list input. </summary>
    public partial class SqlVulnerabilityAssessmentBaselineCreateOrUpdateContent : ResourceData
    {
        /// <summary>
        /// Keeps track of any properties unknown to the library.
        /// <para>
        /// To assign an object to the value of this property use <see cref="BinaryData.FromObjectAsJson{T}(T, System.Text.Json.JsonSerializerOptions?)"/>.
        /// </para>
        /// <para>
        /// To assign an already formatted json string to this property use <see cref="BinaryData.FromString(string)"/>.
        /// </para>
        /// <para>
        /// Examples:
        /// <list type="bullet">
        /// <item>
        /// <term>BinaryData.FromObjectAsJson("foo")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("\"foo\"")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromObjectAsJson(new { key = "value" })</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("{\"key\": \"value\"}")</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// </list>
        /// </para>
        /// </summary>
        private IDictionary<string, BinaryData> _serializedAdditionalRawData;

        /// <summary> Initializes a new instance of <see cref="SqlVulnerabilityAssessmentBaselineCreateOrUpdateContent"/>. </summary>
        public SqlVulnerabilityAssessmentBaselineCreateOrUpdateContent()
        {
            Results = new ChangeTrackingDictionary<string, IList<IList<string>>>();
        }

        /// <summary> Initializes a new instance of <see cref="SqlVulnerabilityAssessmentBaselineCreateOrUpdateContent"/>. </summary>
        /// <param name="id"> The id. </param>
        /// <param name="name"> The name. </param>
        /// <param name="resourceType"> The resourceType. </param>
        /// <param name="systemData"> The systemData. </param>
        /// <param name="isLatestScan"> The latest scan flag. </param>
        /// <param name="results"> The rule baseline result list. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        internal SqlVulnerabilityAssessmentBaselineCreateOrUpdateContent(ResourceIdentifier id, string name, ResourceType resourceType, SystemData systemData, bool? isLatestScan, IDictionary<string, IList<IList<string>>> results, IDictionary<string, BinaryData> serializedAdditionalRawData) : base(id, name, resourceType, systemData)
        {
            IsLatestScan = isLatestScan;
            Results = results;
            _serializedAdditionalRawData = serializedAdditionalRawData;
        }

        /// <summary> The latest scan flag. </summary>
        [WirePath("properties.latestScan")]
        public bool? IsLatestScan { get; set; }
        /// <summary> The rule baseline result list. </summary>
        [WirePath("properties.results")]
        public IDictionary<string, IList<IList<string>>> Results { get; }
    }
}
