// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;

namespace Azure.ResourceManager.Sql.Models
{
    /// <summary> SQL Vulnerability Assessment baseline adjusted results. </summary>
    public partial class SqlVulnerabilityAssessmentBaselineAdjustedResult
    {
        /// <summary>
        /// Keeps track of any properties unknown to the library.
        /// <para>
        /// To assign an object to the value of this property use <see cref="BinaryData.FromObjectAsJson{T}(T, System.Text.Json.JsonSerializerOptions?)"/>.
        /// </para>
        /// <para>
        /// To assign an already formatted json string to this property use <see cref="BinaryData.FromString(string)"/>.
        /// </para>
        /// <para>
        /// Examples:
        /// <list type="bullet">
        /// <item>
        /// <term>BinaryData.FromObjectAsJson("foo")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("\"foo\"")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromObjectAsJson(new { key = "value" })</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("{\"key\": \"value\"}")</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// </list>
        /// </para>
        /// </summary>
        private IDictionary<string, BinaryData> _serializedAdditionalRawData;

        /// <summary> Initializes a new instance of <see cref="SqlVulnerabilityAssessmentBaselineAdjustedResult"/>. </summary>
        internal SqlVulnerabilityAssessmentBaselineAdjustedResult()
        {
            ResultsNotInBaseline = new ChangeTrackingList<IList<string>>();
            ResultsOnlyInBaseline = new ChangeTrackingList<IList<string>>();
        }

        /// <summary> Initializes a new instance of <see cref="SqlVulnerabilityAssessmentBaselineAdjustedResult"/>. </summary>
        /// <param name="baseline"> SQL Vulnerability Assessment baseline details. </param>
        /// <param name="status"> SQL Vulnerability Assessment baseline status. </param>
        /// <param name="resultsNotInBaseline"> SQL Vulnerability Assessment results that are not in baseline. </param>
        /// <param name="resultsOnlyInBaseline"> SQL Vulnerability Assessment results that are in baseline. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        internal SqlVulnerabilityAssessmentBaselineAdjustedResult(SqlVulnerabilityAssessmentBaselineDetails baseline, SqlVulnerabilityAssessmentRuleStatus? status, IReadOnlyList<IList<string>> resultsNotInBaseline, IReadOnlyList<IList<string>> resultsOnlyInBaseline, IDictionary<string, BinaryData> serializedAdditionalRawData)
        {
            Baseline = baseline;
            Status = status;
            ResultsNotInBaseline = resultsNotInBaseline;
            ResultsOnlyInBaseline = resultsOnlyInBaseline;
            _serializedAdditionalRawData = serializedAdditionalRawData;
        }

        /// <summary> SQL Vulnerability Assessment baseline details. </summary>
        [WirePath("baseline")]
        public SqlVulnerabilityAssessmentBaselineDetails Baseline { get; }
        /// <summary> SQL Vulnerability Assessment baseline status. </summary>
        [WirePath("status")]
        public SqlVulnerabilityAssessmentRuleStatus? Status { get; }
        /// <summary> SQL Vulnerability Assessment results that are not in baseline. </summary>
        [WirePath("resultsNotInBaseline")]
        public IReadOnlyList<IList<string>> ResultsNotInBaseline { get; }
        /// <summary> SQL Vulnerability Assessment results that are in baseline. </summary>
        [WirePath("resultsOnlyInBaseline")]
        public IReadOnlyList<IList<string>> ResultsOnlyInBaseline { get; }
    }
}
