// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;

namespace Azure.ResourceManager.Sql.Models
{
    /// <summary> An ARM Resource SKU. </summary>
    public partial class SqlSku
    {
        /// <summary>
        /// Keeps track of any properties unknown to the library.
        /// <para>
        /// To assign an object to the value of this property use <see cref="BinaryData.FromObjectAsJson{T}(T, System.Text.Json.JsonSerializerOptions?)"/>.
        /// </para>
        /// <para>
        /// To assign an already formatted json string to this property use <see cref="BinaryData.FromString(string)"/>.
        /// </para>
        /// <para>
        /// Examples:
        /// <list type="bullet">
        /// <item>
        /// <term>BinaryData.FromObjectAsJson("foo")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("\"foo\"")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromObjectAsJson(new { key = "value" })</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("{\"key\": \"value\"}")</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// </list>
        /// </para>
        /// </summary>
        private IDictionary<string, BinaryData> _serializedAdditionalRawData;

        /// <summary> Initializes a new instance of <see cref="SqlSku"/>. </summary>
        /// <param name="name"> The name of the SKU, typically, a letter + Number code, e.g. P3. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="name"/> is null. </exception>
        public SqlSku(string name)
        {
            Argument.AssertNotNull(name, nameof(name));

            Name = name;
        }

        /// <summary> Initializes a new instance of <see cref="SqlSku"/>. </summary>
        /// <param name="name"> The name of the SKU, typically, a letter + Number code, e.g. P3. </param>
        /// <param name="tier"> The tier or edition of the particular SKU, e.g. Basic, Premium. </param>
        /// <param name="size"> Size of the particular SKU. </param>
        /// <param name="family"> If the service has different generations of hardware, for the same SKU, then that can be captured here. </param>
        /// <param name="capacity"> Capacity of the particular SKU. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        internal SqlSku(string name, string tier, string size, string family, int? capacity, IDictionary<string, BinaryData> serializedAdditionalRawData)
        {
            Name = name;
            Tier = tier;
            Size = size;
            Family = family;
            Capacity = capacity;
            _serializedAdditionalRawData = serializedAdditionalRawData;
        }

        /// <summary> Initializes a new instance of <see cref="SqlSku"/> for deserialization. </summary>
        internal SqlSku()
        {
        }

        /// <summary> The name of the SKU, typically, a letter + Number code, e.g. P3. </summary>
        [WirePath("name")]
        public string Name { get; set; }
        /// <summary> The tier or edition of the particular SKU, e.g. Basic, Premium. </summary>
        [WirePath("tier")]
        public string Tier { get; set; }
        /// <summary> Size of the particular SKU. </summary>
        [WirePath("size")]
        public string Size { get; set; }
        /// <summary> If the service has different generations of hardware, for the same SKU, then that can be captured here. </summary>
        [WirePath("family")]
        public string Family { get; set; }
        /// <summary> Capacity of the particular SKU. </summary>
        [WirePath("capacity")]
        public int? Capacity { get; set; }
    }
}
