// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.Sql.Models
{
    /// <summary> Service principal type. </summary>
    public readonly partial struct SqlServicePrincipalType : IEquatable<SqlServicePrincipalType>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="SqlServicePrincipalType"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public SqlServicePrincipalType(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string NoneValue = "None";
        private const string SystemAssignedValue = "SystemAssigned";

        /// <summary> None. </summary>
        public static SqlServicePrincipalType None { get; } = new SqlServicePrincipalType(NoneValue);
        /// <summary> SystemAssigned. </summary>
        public static SqlServicePrincipalType SystemAssigned { get; } = new SqlServicePrincipalType(SystemAssignedValue);
        /// <summary> Determines if two <see cref="SqlServicePrincipalType"/> values are the same. </summary>
        public static bool operator ==(SqlServicePrincipalType left, SqlServicePrincipalType right) => left.Equals(right);
        /// <summary> Determines if two <see cref="SqlServicePrincipalType"/> values are not the same. </summary>
        public static bool operator !=(SqlServicePrincipalType left, SqlServicePrincipalType right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="SqlServicePrincipalType"/>. </summary>
        public static implicit operator SqlServicePrincipalType(string value) => new SqlServicePrincipalType(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is SqlServicePrincipalType other && Equals(other);
        /// <inheritdoc />
        public bool Equals(SqlServicePrincipalType other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
