// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;

namespace Azure.ResourceManager.Sql.Models
{
    /// <summary> The managed instance's service principal configuration for a resource. </summary>
    public partial class SqlServicePrincipal
    {
        /// <summary>
        /// Keeps track of any properties unknown to the library.
        /// <para>
        /// To assign an object to the value of this property use <see cref="BinaryData.FromObjectAsJson{T}(T, System.Text.Json.JsonSerializerOptions?)"/>.
        /// </para>
        /// <para>
        /// To assign an already formatted json string to this property use <see cref="BinaryData.FromString(string)"/>.
        /// </para>
        /// <para>
        /// Examples:
        /// <list type="bullet">
        /// <item>
        /// <term>BinaryData.FromObjectAsJson("foo")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("\"foo\"")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromObjectAsJson(new { key = "value" })</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("{\"key\": \"value\"}")</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// </list>
        /// </para>
        /// </summary>
        private IDictionary<string, BinaryData> _serializedAdditionalRawData;

        /// <summary> Initializes a new instance of <see cref="SqlServicePrincipal"/>. </summary>
        public SqlServicePrincipal()
        {
        }

        /// <summary> Initializes a new instance of <see cref="SqlServicePrincipal"/>. </summary>
        /// <param name="principalId"> The Azure Active Directory application object id. </param>
        /// <param name="clientId"> The Azure Active Directory application client id. </param>
        /// <param name="tenantId"> The Azure Active Directory tenant id. </param>
        /// <param name="principalType"> Service principal type. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        internal SqlServicePrincipal(Guid? principalId, Guid? clientId, Guid? tenantId, SqlServicePrincipalType? principalType, IDictionary<string, BinaryData> serializedAdditionalRawData)
        {
            PrincipalId = principalId;
            ClientId = clientId;
            TenantId = tenantId;
            PrincipalType = principalType;
            _serializedAdditionalRawData = serializedAdditionalRawData;
        }

        /// <summary> The Azure Active Directory application object id. </summary>
        [WirePath("principalId")]
        public Guid? PrincipalId { get; }
        /// <summary> The Azure Active Directory application client id. </summary>
        [WirePath("clientId")]
        public Guid? ClientId { get; }
        /// <summary> The Azure Active Directory tenant id. </summary>
        [WirePath("tenantId")]
        public Guid? TenantId { get; }
        /// <summary> Service principal type. </summary>
        [WirePath("type")]
        public SqlServicePrincipalType? PrincipalType { get; set; }
    }
}
