// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;

namespace Azure.ResourceManager.Sql.Models
{
    /// <summary> Represents server metrics. </summary>
    public partial class SqlServerUsage
    {
        /// <summary>
        /// Keeps track of any properties unknown to the library.
        /// <para>
        /// To assign an object to the value of this property use <see cref="BinaryData.FromObjectAsJson{T}(T, System.Text.Json.JsonSerializerOptions?)"/>.
        /// </para>
        /// <para>
        /// To assign an already formatted json string to this property use <see cref="BinaryData.FromString(string)"/>.
        /// </para>
        /// <para>
        /// Examples:
        /// <list type="bullet">
        /// <item>
        /// <term>BinaryData.FromObjectAsJson("foo")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("\"foo\"")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromObjectAsJson(new { key = "value" })</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("{\"key\": \"value\"}")</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// </list>
        /// </para>
        /// </summary>
        private IDictionary<string, BinaryData> _serializedAdditionalRawData;

        /// <summary> Initializes a new instance of <see cref="SqlServerUsage"/>. </summary>
        internal SqlServerUsage()
        {
        }

        /// <summary> Initializes a new instance of <see cref="SqlServerUsage"/>. </summary>
        /// <param name="name"> Name of the server usage metric. </param>
        /// <param name="resourceName"> The name of the resource. </param>
        /// <param name="displayName"> The metric display name. </param>
        /// <param name="currentValue"> The current value of the metric. </param>
        /// <param name="limit"> The current limit of the metric. </param>
        /// <param name="unit"> The units of the metric. </param>
        /// <param name="nextResetOn"> The next reset time for the metric (ISO8601 format). </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        internal SqlServerUsage(string name, string resourceName, string displayName, double? currentValue, double? limit, string unit, DateTimeOffset? nextResetOn, IDictionary<string, BinaryData> serializedAdditionalRawData)
        {
            Name = name;
            ResourceName = resourceName;
            DisplayName = displayName;
            CurrentValue = currentValue;
            Limit = limit;
            Unit = unit;
            NextResetOn = nextResetOn;
            _serializedAdditionalRawData = serializedAdditionalRawData;
        }

        /// <summary> Name of the server usage metric. </summary>
        [WirePath("name")]
        public string Name { get; }
        /// <summary> The name of the resource. </summary>
        [WirePath("resourceName")]
        public string ResourceName { get; }
        /// <summary> The metric display name. </summary>
        [WirePath("displayName")]
        public string DisplayName { get; }
        /// <summary> The current value of the metric. </summary>
        [WirePath("currentValue")]
        public double? CurrentValue { get; }
        /// <summary> The current limit of the metric. </summary>
        [WirePath("limit")]
        public double? Limit { get; }
        /// <summary> The units of the metric. </summary>
        [WirePath("unit")]
        public string Unit { get; }
        /// <summary> The next reset time for the metric (ISO8601 format). </summary>
        [WirePath("nextResetTime")]
        public DateTimeOffset? NextResetOn { get; }
    }
}
