// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.Sql.Models
{
    /// <summary> Principal Type of the sever administrator. </summary>
    public readonly partial struct SqlServerPrincipalType : IEquatable<SqlServerPrincipalType>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="SqlServerPrincipalType"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public SqlServerPrincipalType(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string UserValue = "User";
        private const string GroupValue = "Group";
        private const string ApplicationValue = "Application";

        /// <summary> User. </summary>
        public static SqlServerPrincipalType User { get; } = new SqlServerPrincipalType(UserValue);
        /// <summary> Group. </summary>
        public static SqlServerPrincipalType Group { get; } = new SqlServerPrincipalType(GroupValue);
        /// <summary> Application. </summary>
        public static SqlServerPrincipalType Application { get; } = new SqlServerPrincipalType(ApplicationValue);
        /// <summary> Determines if two <see cref="SqlServerPrincipalType"/> values are the same. </summary>
        public static bool operator ==(SqlServerPrincipalType left, SqlServerPrincipalType right) => left.Equals(right);
        /// <summary> Determines if two <see cref="SqlServerPrincipalType"/> values are not the same. </summary>
        public static bool operator !=(SqlServerPrincipalType left, SqlServerPrincipalType right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="SqlServerPrincipalType"/>. </summary>
        public static implicit operator SqlServerPrincipalType(string value) => new SqlServerPrincipalType(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is SqlServerPrincipalType other && Equals(other);
        /// <inheritdoc />
        public bool Equals(SqlServerPrincipalType other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
