// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;

namespace Azure.ResourceManager.Sql.Models
{
    /// <summary> Scheduling properties of a job. </summary>
    public partial class SqlServerJobSchedule
    {
        /// <summary>
        /// Keeps track of any properties unknown to the library.
        /// <para>
        /// To assign an object to the value of this property use <see cref="BinaryData.FromObjectAsJson{T}(T, System.Text.Json.JsonSerializerOptions?)"/>.
        /// </para>
        /// <para>
        /// To assign an already formatted json string to this property use <see cref="BinaryData.FromString(string)"/>.
        /// </para>
        /// <para>
        /// Examples:
        /// <list type="bullet">
        /// <item>
        /// <term>BinaryData.FromObjectAsJson("foo")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("\"foo\"")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromObjectAsJson(new { key = "value" })</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("{\"key\": \"value\"}")</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// </list>
        /// </para>
        /// </summary>
        private IDictionary<string, BinaryData> _serializedAdditionalRawData;

        /// <summary> Initializes a new instance of <see cref="SqlServerJobSchedule"/>. </summary>
        public SqlServerJobSchedule()
        {
        }

        /// <summary> Initializes a new instance of <see cref="SqlServerJobSchedule"/>. </summary>
        /// <param name="startOn"> Schedule start time. </param>
        /// <param name="endOn"> Schedule end time. </param>
        /// <param name="scheduleType"> Schedule interval type. </param>
        /// <param name="isEnabled"> Whether or not the schedule is enabled. </param>
        /// <param name="interval"> Value of the schedule's recurring interval, if the ScheduleType is recurring. ISO8601 duration format. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        internal SqlServerJobSchedule(DateTimeOffset? startOn, DateTimeOffset? endOn, SqlServerJobScheduleType? scheduleType, bool? isEnabled, TimeSpan? interval, IDictionary<string, BinaryData> serializedAdditionalRawData)
        {
            StartOn = startOn;
            EndOn = endOn;
            ScheduleType = scheduleType;
            IsEnabled = isEnabled;
            Interval = interval;
            _serializedAdditionalRawData = serializedAdditionalRawData;
        }

        /// <summary> Schedule start time. </summary>
        [WirePath("startTime")]
        public DateTimeOffset? StartOn { get; set; }
        /// <summary> Schedule end time. </summary>
        [WirePath("endTime")]
        public DateTimeOffset? EndOn { get; set; }
        /// <summary> Schedule interval type. </summary>
        [WirePath("type")]
        public SqlServerJobScheduleType? ScheduleType { get; set; }
        /// <summary> Whether or not the schedule is enabled. </summary>
        [WirePath("enabled")]
        public bool? IsEnabled { get; set; }
        /// <summary> Value of the schedule's recurring interval, if the ScheduleType is recurring. ISO8601 duration format. </summary>
        [WirePath("interval")]
        public TimeSpan? Interval { get; set; }
    }
}
