// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;

namespace Azure.ResourceManager.Sql.Models
{
    internal static partial class SqlServerDatabaseReplicationRoleExtensions
    {
        public static string ToSerialString(this SqlServerDatabaseReplicationRole value) => value switch
        {
            SqlServerDatabaseReplicationRole.Primary => "Primary",
            SqlServerDatabaseReplicationRole.Secondary => "Secondary",
            SqlServerDatabaseReplicationRole.NonReadableSecondary => "NonReadableSecondary",
            SqlServerDatabaseReplicationRole.Source => "Source",
            SqlServerDatabaseReplicationRole.Copy => "Copy",
            _ => throw new ArgumentOutOfRangeException(nameof(value), value, "Unknown SqlServerDatabaseReplicationRole value.")
        };

        public static SqlServerDatabaseReplicationRole ToSqlServerDatabaseReplicationRole(this string value)
        {
            if (StringComparer.OrdinalIgnoreCase.Equals(value, "Primary")) return SqlServerDatabaseReplicationRole.Primary;
            if (StringComparer.OrdinalIgnoreCase.Equals(value, "Secondary")) return SqlServerDatabaseReplicationRole.Secondary;
            if (StringComparer.OrdinalIgnoreCase.Equals(value, "NonReadableSecondary")) return SqlServerDatabaseReplicationRole.NonReadableSecondary;
            if (StringComparer.OrdinalIgnoreCase.Equals(value, "Source")) return SqlServerDatabaseReplicationRole.Source;
            if (StringComparer.OrdinalIgnoreCase.Equals(value, "Copy")) return SqlServerDatabaseReplicationRole.Copy;
            throw new ArgumentOutOfRangeException(nameof(value), value, "Unknown SqlServerDatabaseReplicationRole value.");
        }
    }
}
