// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.Sql.Models
{
    /// <summary> The SqlSecurityAlertPolicyName. </summary>
    public readonly partial struct SqlSecurityAlertPolicyName : IEquatable<SqlSecurityAlertPolicyName>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="SqlSecurityAlertPolicyName"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public SqlSecurityAlertPolicyName(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string DefaultValue = "Default";

        /// <summary> Default. </summary>
        public static SqlSecurityAlertPolicyName Default { get; } = new SqlSecurityAlertPolicyName(DefaultValue);
        /// <summary> Determines if two <see cref="SqlSecurityAlertPolicyName"/> values are the same. </summary>
        public static bool operator ==(SqlSecurityAlertPolicyName left, SqlSecurityAlertPolicyName right) => left.Equals(right);
        /// <summary> Determines if two <see cref="SqlSecurityAlertPolicyName"/> values are not the same. </summary>
        public static bool operator !=(SqlSecurityAlertPolicyName left, SqlSecurityAlertPolicyName right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="SqlSecurityAlertPolicyName"/>. </summary>
        public static implicit operator SqlSecurityAlertPolicyName(string value) => new SqlSecurityAlertPolicyName(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is SqlSecurityAlertPolicyName other && Equals(other);
        /// <inheritdoc />
        public bool Equals(SqlSecurityAlertPolicyName other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
