// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.Sql.Models
{
    /// <summary> The private link service connection status. </summary>
    public readonly partial struct SqlPrivateLinkServiceConnectionStatus : IEquatable<SqlPrivateLinkServiceConnectionStatus>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="SqlPrivateLinkServiceConnectionStatus"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public SqlPrivateLinkServiceConnectionStatus(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string ApprovedValue = "Approved";
        private const string PendingValue = "Pending";
        private const string RejectedValue = "Rejected";
        private const string DisconnectedValue = "Disconnected";

        /// <summary> Approved. </summary>
        public static SqlPrivateLinkServiceConnectionStatus Approved { get; } = new SqlPrivateLinkServiceConnectionStatus(ApprovedValue);
        /// <summary> Pending. </summary>
        public static SqlPrivateLinkServiceConnectionStatus Pending { get; } = new SqlPrivateLinkServiceConnectionStatus(PendingValue);
        /// <summary> Rejected. </summary>
        public static SqlPrivateLinkServiceConnectionStatus Rejected { get; } = new SqlPrivateLinkServiceConnectionStatus(RejectedValue);
        /// <summary> Disconnected. </summary>
        public static SqlPrivateLinkServiceConnectionStatus Disconnected { get; } = new SqlPrivateLinkServiceConnectionStatus(DisconnectedValue);
        /// <summary> Determines if two <see cref="SqlPrivateLinkServiceConnectionStatus"/> values are the same. </summary>
        public static bool operator ==(SqlPrivateLinkServiceConnectionStatus left, SqlPrivateLinkServiceConnectionStatus right) => left.Equals(right);
        /// <summary> Determines if two <see cref="SqlPrivateLinkServiceConnectionStatus"/> values are not the same. </summary>
        public static bool operator !=(SqlPrivateLinkServiceConnectionStatus left, SqlPrivateLinkServiceConnectionStatus right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="SqlPrivateLinkServiceConnectionStatus"/>. </summary>
        public static implicit operator SqlPrivateLinkServiceConnectionStatus(string value) => new SqlPrivateLinkServiceConnectionStatus(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is SqlPrivateLinkServiceConnectionStatus other && Equals(other);
        /// <inheritdoc />
        public bool Equals(SqlPrivateLinkServiceConnectionStatus other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
