// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.Sql.Models
{
    /// <summary> The actions required for private link service connection. </summary>
    public readonly partial struct SqlPrivateLinkServiceConnectionActionsRequired : IEquatable<SqlPrivateLinkServiceConnectionActionsRequired>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="SqlPrivateLinkServiceConnectionActionsRequired"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public SqlPrivateLinkServiceConnectionActionsRequired(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string NoneValue = "None";

        /// <summary> None. </summary>
        public static SqlPrivateLinkServiceConnectionActionsRequired None { get; } = new SqlPrivateLinkServiceConnectionActionsRequired(NoneValue);
        /// <summary> Determines if two <see cref="SqlPrivateLinkServiceConnectionActionsRequired"/> values are the same. </summary>
        public static bool operator ==(SqlPrivateLinkServiceConnectionActionsRequired left, SqlPrivateLinkServiceConnectionActionsRequired right) => left.Equals(right);
        /// <summary> Determines if two <see cref="SqlPrivateLinkServiceConnectionActionsRequired"/> values are not the same. </summary>
        public static bool operator !=(SqlPrivateLinkServiceConnectionActionsRequired left, SqlPrivateLinkServiceConnectionActionsRequired right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="SqlPrivateLinkServiceConnectionActionsRequired"/>. </summary>
        public static implicit operator SqlPrivateLinkServiceConnectionActionsRequired(string value) => new SqlPrivateLinkServiceConnectionActionsRequired(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is SqlPrivateLinkServiceConnectionActionsRequired other && Equals(other);
        /// <inheritdoc />
        public bool Equals(SqlPrivateLinkServiceConnectionActionsRequired other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
