// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;

namespace Azure.ResourceManager.Sql.Models
{
    /// <summary> An endpoint that the managed instance service requires outbound network access to. </summary>
    public partial class SqlOutboundEnvironmentEndpoint
    {
        /// <summary>
        /// Keeps track of any properties unknown to the library.
        /// <para>
        /// To assign an object to the value of this property use <see cref="BinaryData.FromObjectAsJson{T}(T, System.Text.Json.JsonSerializerOptions?)"/>.
        /// </para>
        /// <para>
        /// To assign an already formatted json string to this property use <see cref="BinaryData.FromString(string)"/>.
        /// </para>
        /// <para>
        /// Examples:
        /// <list type="bullet">
        /// <item>
        /// <term>BinaryData.FromObjectAsJson("foo")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("\"foo\"")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromObjectAsJson(new { key = "value" })</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("{\"key\": \"value\"}")</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// </list>
        /// </para>
        /// </summary>
        private IDictionary<string, BinaryData> _serializedAdditionalRawData;

        /// <summary> Initializes a new instance of <see cref="SqlOutboundEnvironmentEndpoint"/>. </summary>
        internal SqlOutboundEnvironmentEndpoint()
        {
            Endpoints = new ChangeTrackingList<ManagedInstanceEndpointDependency>();
        }

        /// <summary> Initializes a new instance of <see cref="SqlOutboundEnvironmentEndpoint"/>. </summary>
        /// <param name="category"> The type of service accessed by the managed instance service, e.g., Azure Storage, Azure Active Directory, etc. </param>
        /// <param name="endpoints"> The endpoints that the managed instance service communicates with in order to function correctly. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        internal SqlOutboundEnvironmentEndpoint(string category, IReadOnlyList<ManagedInstanceEndpointDependency> endpoints, IDictionary<string, BinaryData> serializedAdditionalRawData)
        {
            Category = category;
            Endpoints = endpoints;
            _serializedAdditionalRawData = serializedAdditionalRawData;
        }

        /// <summary> The type of service accessed by the managed instance service, e.g., Azure Storage, Azure Active Directory, etc. </summary>
        [WirePath("category")]
        public string Category { get; }
        /// <summary> The endpoints that the managed instance service communicates with in order to function correctly. </summary>
        [WirePath("endpoints")]
        public IReadOnlyList<ManagedInstanceEndpointDependency> Endpoints { get; }
    }
}
