// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;

namespace Azure.ResourceManager.Sql.Models
{
    internal static partial class SqlNameUnavailableReasonExtensions
    {
        public static string ToSerialString(this SqlNameUnavailableReason value) => value switch
        {
            SqlNameUnavailableReason.Invalid => "Invalid",
            SqlNameUnavailableReason.AlreadyExists => "AlreadyExists",
            _ => throw new ArgumentOutOfRangeException(nameof(value), value, "Unknown SqlNameUnavailableReason value.")
        };

        public static SqlNameUnavailableReason ToSqlNameUnavailableReason(this string value)
        {
            if (StringComparer.OrdinalIgnoreCase.Equals(value, "Invalid")) return SqlNameUnavailableReason.Invalid;
            if (StringComparer.OrdinalIgnoreCase.Equals(value, "AlreadyExists")) return SqlNameUnavailableReason.AlreadyExists;
            throw new ArgumentOutOfRangeException(nameof(value), value, "Unknown SqlNameUnavailableReason value.");
        }
    }
}
