// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;

namespace Azure.ResourceManager.Sql.Models
{
    /// <summary> The result of a name availability check. </summary>
    public partial class SqlNameAvailabilityResponse
    {
        /// <summary>
        /// Keeps track of any properties unknown to the library.
        /// <para>
        /// To assign an object to the value of this property use <see cref="BinaryData.FromObjectAsJson{T}(T, System.Text.Json.JsonSerializerOptions?)"/>.
        /// </para>
        /// <para>
        /// To assign an already formatted json string to this property use <see cref="BinaryData.FromString(string)"/>.
        /// </para>
        /// <para>
        /// Examples:
        /// <list type="bullet">
        /// <item>
        /// <term>BinaryData.FromObjectAsJson("foo")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("\"foo\"")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromObjectAsJson(new { key = "value" })</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("{\"key\": \"value\"}")</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// </list>
        /// </para>
        /// </summary>
        private IDictionary<string, BinaryData> _serializedAdditionalRawData;

        /// <summary> Initializes a new instance of <see cref="SqlNameAvailabilityResponse"/>. </summary>
        internal SqlNameAvailabilityResponse()
        {
        }

        /// <summary> Initializes a new instance of <see cref="SqlNameAvailabilityResponse"/>. </summary>
        /// <param name="name"> The name whose availability was checked. </param>
        /// <param name="isAvailable"> True if the name is available, otherwise false. </param>
        /// <param name="reason"> The reason code explaining why the name is unavailable. Will be undefined if the name is available. </param>
        /// <param name="message"> A message explaining why the name is unavailable. Will be undefined if the name is available. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        internal SqlNameAvailabilityResponse(string name, bool? isAvailable, SqlNameUnavailableReason? reason, string message, IDictionary<string, BinaryData> serializedAdditionalRawData)
        {
            Name = name;
            IsAvailable = isAvailable;
            Reason = reason;
            Message = message;
            _serializedAdditionalRawData = serializedAdditionalRawData;
        }

        /// <summary> The name whose availability was checked. </summary>
        [WirePath("name")]
        public string Name { get; }
        /// <summary> True if the name is available, otherwise false. </summary>
        [WirePath("available")]
        public bool? IsAvailable { get; }
        /// <summary> The reason code explaining why the name is unavailable. Will be undefined if the name is available. </summary>
        [WirePath("reason")]
        public SqlNameUnavailableReason? Reason { get; }
        /// <summary> A message explaining why the name is unavailable. Will be undefined if the name is available. </summary>
        [WirePath("message")]
        public string Message { get; }
    }
}
