// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.Sql.Models
{
    /// <summary> The SqlNameAvailabilityResourceType. </summary>
    public readonly partial struct SqlNameAvailabilityResourceType : IEquatable<SqlNameAvailabilityResourceType>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="SqlNameAvailabilityResourceType"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public SqlNameAvailabilityResourceType(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string MicrosoftSqlServersValue = "Microsoft.Sql/servers";

        /// <summary> Microsoft.Sql/servers. </summary>
        public static SqlNameAvailabilityResourceType MicrosoftSqlServers { get; } = new SqlNameAvailabilityResourceType(MicrosoftSqlServersValue);
        /// <summary> Determines if two <see cref="SqlNameAvailabilityResourceType"/> values are the same. </summary>
        public static bool operator ==(SqlNameAvailabilityResourceType left, SqlNameAvailabilityResourceType right) => left.Equals(right);
        /// <summary> Determines if two <see cref="SqlNameAvailabilityResourceType"/> values are not the same. </summary>
        public static bool operator !=(SqlNameAvailabilityResourceType left, SqlNameAvailabilityResourceType right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="SqlNameAvailabilityResourceType"/>. </summary>
        public static implicit operator SqlNameAvailabilityResourceType(string value) => new SqlNameAvailabilityResourceType(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is SqlNameAvailabilityResourceType other && Equals(other);
        /// <inheritdoc />
        public bool Equals(SqlNameAvailabilityResourceType other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
