// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.Sql.Models
{
    /// <summary> Minimal TLS version. Allowed values: 'None', 1.0', '1.1', '1.2', '1.3'. </summary>
    public readonly partial struct SqlMinimalTlsVersion : IEquatable<SqlMinimalTlsVersion>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="SqlMinimalTlsVersion"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public SqlMinimalTlsVersion(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string TlsNoneValue = "None";
        private const string Tls1_0Value = "1.0";
        private const string Tls1_1Value = "1.1";
        private const string Tls1_2Value = "1.2";
        private const string Tls1_3Value = "1.3";
        /// <summary> Determines if two <see cref="SqlMinimalTlsVersion"/> values are the same. </summary>
        public static bool operator ==(SqlMinimalTlsVersion left, SqlMinimalTlsVersion right) => left.Equals(right);
        /// <summary> Determines if two <see cref="SqlMinimalTlsVersion"/> values are not the same. </summary>
        public static bool operator !=(SqlMinimalTlsVersion left, SqlMinimalTlsVersion right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="SqlMinimalTlsVersion"/>. </summary>
        public static implicit operator SqlMinimalTlsVersion(string value) => new SqlMinimalTlsVersion(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is SqlMinimalTlsVersion other && Equals(other);
        /// <inheritdoc />
        public bool Equals(SqlMinimalTlsVersion other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
