// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.Sql.Models
{
    /// <summary> The database key type. Only supported value is 'AzureKeyVault'. </summary>
    public readonly partial struct SqlDatabaseKeyType : IEquatable<SqlDatabaseKeyType>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="SqlDatabaseKeyType"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public SqlDatabaseKeyType(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string AzureKeyVaultValue = "AzureKeyVault";

        /// <summary> AzureKeyVault. </summary>
        public static SqlDatabaseKeyType AzureKeyVault { get; } = new SqlDatabaseKeyType(AzureKeyVaultValue);
        /// <summary> Determines if two <see cref="SqlDatabaseKeyType"/> values are the same. </summary>
        public static bool operator ==(SqlDatabaseKeyType left, SqlDatabaseKeyType right) => left.Equals(right);
        /// <summary> Determines if two <see cref="SqlDatabaseKeyType"/> values are not the same. </summary>
        public static bool operator !=(SqlDatabaseKeyType left, SqlDatabaseKeyType right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="SqlDatabaseKeyType"/>. </summary>
        public static implicit operator SqlDatabaseKeyType(string value) => new SqlDatabaseKeyType(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is SqlDatabaseKeyType other && Equals(other);
        /// <inheritdoc />
        public bool Equals(SqlDatabaseKeyType other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
