// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.Sql.Models
{
    /// <summary> The column data type. </summary>
    public readonly partial struct SqlColumnDataType : IEquatable<SqlColumnDataType>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="SqlColumnDataType"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public SqlColumnDataType(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string ImageValue = "image";
        private const string TextValue = "text";
        private const string UniqueidentifierValue = "uniqueidentifier";
        private const string DateValue = "date";
        private const string TimeValue = "time";
        private const string Datetime2Value = "datetime2";
        private const string DatetimeoffsetValue = "datetimeoffset";
        private const string TinyintValue = "tinyint";
        private const string SmallintValue = "smallint";
        private const string IntValue = "int";
        private const string SmalldatetimeValue = "smalldatetime";
        private const string RealValue = "real";
        private const string MoneyValue = "money";
        private const string DatetimeValue = "datetime";
        private const string FloatValue = "float";
        private const string SqlVariantValue = "sql_variant";
        private const string NtextValue = "ntext";
        private const string BitValue = "bit";
        private const string DecimalValue = "decimal";
        private const string NumericValue = "numeric";
        private const string SmallmoneyValue = "smallmoney";
        private const string BigintValue = "bigint";
        private const string HierarchyIdValue = "hierarchyid";
        private const string GeometryValue = "geometry";
        private const string GeographyValue = "geography";
        private const string VarbinaryValue = "varbinary";
        private const string VarcharValue = "varchar";
        private const string BinaryValue = "binary";
        private const string CharValue = "char";
        private const string TimestampValue = "timestamp";
        private const string NvarcharValue = "nvarchar";
        private const string NcharValue = "nchar";
        private const string XmlValue = "xml";
        private const string SysnameValue = "sysname";

        /// <summary> image. </summary>
        public static SqlColumnDataType Image { get; } = new SqlColumnDataType(ImageValue);
        /// <summary> text. </summary>
        public static SqlColumnDataType Text { get; } = new SqlColumnDataType(TextValue);
        /// <summary> uniqueidentifier. </summary>
        public static SqlColumnDataType Uniqueidentifier { get; } = new SqlColumnDataType(UniqueidentifierValue);
        /// <summary> date. </summary>
        public static SqlColumnDataType Date { get; } = new SqlColumnDataType(DateValue);
        /// <summary> time. </summary>
        public static SqlColumnDataType Time { get; } = new SqlColumnDataType(TimeValue);
        /// <summary> datetime2. </summary>
        public static SqlColumnDataType Datetime2 { get; } = new SqlColumnDataType(Datetime2Value);
        /// <summary> datetimeoffset. </summary>
        public static SqlColumnDataType Datetimeoffset { get; } = new SqlColumnDataType(DatetimeoffsetValue);
        /// <summary> tinyint. </summary>
        public static SqlColumnDataType Tinyint { get; } = new SqlColumnDataType(TinyintValue);
        /// <summary> smallint. </summary>
        public static SqlColumnDataType Smallint { get; } = new SqlColumnDataType(SmallintValue);
        /// <summary> int. </summary>
        public static SqlColumnDataType Int { get; } = new SqlColumnDataType(IntValue);
        /// <summary> smalldatetime. </summary>
        public static SqlColumnDataType Smalldatetime { get; } = new SqlColumnDataType(SmalldatetimeValue);
        /// <summary> real. </summary>
        public static SqlColumnDataType Real { get; } = new SqlColumnDataType(RealValue);
        /// <summary> money. </summary>
        public static SqlColumnDataType Money { get; } = new SqlColumnDataType(MoneyValue);
        /// <summary> datetime. </summary>
        public static SqlColumnDataType Datetime { get; } = new SqlColumnDataType(DatetimeValue);
        /// <summary> float. </summary>
        public static SqlColumnDataType Float { get; } = new SqlColumnDataType(FloatValue);
        /// <summary> sql_variant. </summary>
        public static SqlColumnDataType SqlVariant { get; } = new SqlColumnDataType(SqlVariantValue);
        /// <summary> ntext. </summary>
        public static SqlColumnDataType Ntext { get; } = new SqlColumnDataType(NtextValue);
        /// <summary> bit. </summary>
        public static SqlColumnDataType Bit { get; } = new SqlColumnDataType(BitValue);
        /// <summary> decimal. </summary>
        public static SqlColumnDataType Decimal { get; } = new SqlColumnDataType(DecimalValue);
        /// <summary> numeric. </summary>
        public static SqlColumnDataType Numeric { get; } = new SqlColumnDataType(NumericValue);
        /// <summary> smallmoney. </summary>
        public static SqlColumnDataType Smallmoney { get; } = new SqlColumnDataType(SmallmoneyValue);
        /// <summary> bigint. </summary>
        public static SqlColumnDataType Bigint { get; } = new SqlColumnDataType(BigintValue);
        /// <summary> hierarchyid. </summary>
        public static SqlColumnDataType HierarchyId { get; } = new SqlColumnDataType(HierarchyIdValue);
        /// <summary> geometry. </summary>
        public static SqlColumnDataType Geometry { get; } = new SqlColumnDataType(GeometryValue);
        /// <summary> geography. </summary>
        public static SqlColumnDataType Geography { get; } = new SqlColumnDataType(GeographyValue);
        /// <summary> varbinary. </summary>
        public static SqlColumnDataType Varbinary { get; } = new SqlColumnDataType(VarbinaryValue);
        /// <summary> varchar. </summary>
        public static SqlColumnDataType Varchar { get; } = new SqlColumnDataType(VarcharValue);
        /// <summary> binary. </summary>
        public static SqlColumnDataType Binary { get; } = new SqlColumnDataType(BinaryValue);
        /// <summary> char. </summary>
        public static SqlColumnDataType Char { get; } = new SqlColumnDataType(CharValue);
        /// <summary> timestamp. </summary>
        public static SqlColumnDataType Timestamp { get; } = new SqlColumnDataType(TimestampValue);
        /// <summary> nvarchar. </summary>
        public static SqlColumnDataType Nvarchar { get; } = new SqlColumnDataType(NvarcharValue);
        /// <summary> nchar. </summary>
        public static SqlColumnDataType Nchar { get; } = new SqlColumnDataType(NcharValue);
        /// <summary> xml. </summary>
        public static SqlColumnDataType Xml { get; } = new SqlColumnDataType(XmlValue);
        /// <summary> sysname. </summary>
        public static SqlColumnDataType Sysname { get; } = new SqlColumnDataType(SysnameValue);
        /// <summary> Determines if two <see cref="SqlColumnDataType"/> values are the same. </summary>
        public static bool operator ==(SqlColumnDataType left, SqlColumnDataType right) => left.Equals(right);
        /// <summary> Determines if two <see cref="SqlColumnDataType"/> values are not the same. </summary>
        public static bool operator !=(SqlColumnDataType left, SqlColumnDataType right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="SqlColumnDataType"/>. </summary>
        public static implicit operator SqlColumnDataType(string value) => new SqlColumnDataType(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is SqlColumnDataType other && Equals(other);
        /// <inheritdoc />
        public bool Equals(SqlColumnDataType other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
