// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;

namespace Azure.ResourceManager.Sql.Models
{
    internal static partial class SqlCapabilityStatusExtensions
    {
        public static string ToSerialString(this SqlCapabilityStatus value) => value switch
        {
            SqlCapabilityStatus.Default => "Default",
            SqlCapabilityStatus.Visible => "Visible",
            SqlCapabilityStatus.Available => "Available",
            SqlCapabilityStatus.Disabled => "Disabled",
            _ => throw new ArgumentOutOfRangeException(nameof(value), value, "Unknown SqlCapabilityStatus value.")
        };

        public static SqlCapabilityStatus ToSqlCapabilityStatus(this string value)
        {
            if (StringComparer.OrdinalIgnoreCase.Equals(value, "Default")) return SqlCapabilityStatus.Default;
            if (StringComparer.OrdinalIgnoreCase.Equals(value, "Visible")) return SqlCapabilityStatus.Visible;
            if (StringComparer.OrdinalIgnoreCase.Equals(value, "Available")) return SqlCapabilityStatus.Available;
            if (StringComparer.OrdinalIgnoreCase.Equals(value, "Disabled")) return SqlCapabilityStatus.Disabled;
            throw new ArgumentOutOfRangeException(nameof(value), value, "Unknown SqlCapabilityStatus value.");
        }
    }
}
