// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.Sql.Models
{
    /// <summary> The SqlCapabilityGroup. </summary>
    public readonly partial struct SqlCapabilityGroup : IEquatable<SqlCapabilityGroup>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="SqlCapabilityGroup"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public SqlCapabilityGroup(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string SupportedEditionsValue = "supportedEditions";
        private const string SupportedElasticPoolEditionsValue = "supportedElasticPoolEditions";
        private const string SupportedManagedInstanceVersionsValue = "supportedManagedInstanceVersions";
        private const string SupportedInstancePoolEditionsValue = "supportedInstancePoolEditions";
        private const string SupportedManagedInstanceEditionsValue = "supportedManagedInstanceEditions";

        /// <summary> supportedEditions. </summary>
        public static SqlCapabilityGroup SupportedEditions { get; } = new SqlCapabilityGroup(SupportedEditionsValue);
        /// <summary> supportedElasticPoolEditions. </summary>
        public static SqlCapabilityGroup SupportedElasticPoolEditions { get; } = new SqlCapabilityGroup(SupportedElasticPoolEditionsValue);
        /// <summary> supportedManagedInstanceVersions. </summary>
        public static SqlCapabilityGroup SupportedManagedInstanceVersions { get; } = new SqlCapabilityGroup(SupportedManagedInstanceVersionsValue);
        /// <summary> supportedInstancePoolEditions. </summary>
        public static SqlCapabilityGroup SupportedInstancePoolEditions { get; } = new SqlCapabilityGroup(SupportedInstancePoolEditionsValue);
        /// <summary> supportedManagedInstanceEditions. </summary>
        public static SqlCapabilityGroup SupportedManagedInstanceEditions { get; } = new SqlCapabilityGroup(SupportedManagedInstanceEditionsValue);
        /// <summary> Determines if two <see cref="SqlCapabilityGroup"/> values are the same. </summary>
        public static bool operator ==(SqlCapabilityGroup left, SqlCapabilityGroup right) => left.Equals(right);
        /// <summary> Determines if two <see cref="SqlCapabilityGroup"/> values are not the same. </summary>
        public static bool operator !=(SqlCapabilityGroup left, SqlCapabilityGroup right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="SqlCapabilityGroup"/>. </summary>
        public static implicit operator SqlCapabilityGroup(string value) => new SqlCapabilityGroup(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is SqlCapabilityGroup other && Equals(other);
        /// <inheritdoc />
        public bool Equals(SqlCapabilityGroup other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
