// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.Sql.Models
{
    /// <summary> The storage redundancy type of the backup. </summary>
    public readonly partial struct SqlBackupStorageRedundancy : IEquatable<SqlBackupStorageRedundancy>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="SqlBackupStorageRedundancy"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public SqlBackupStorageRedundancy(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string GeoValue = "Geo";
        private const string LocalValue = "Local";
        private const string ZoneValue = "Zone";
        private const string GeoZoneValue = "GeoZone";

        /// <summary> Geo. </summary>
        public static SqlBackupStorageRedundancy Geo { get; } = new SqlBackupStorageRedundancy(GeoValue);
        /// <summary> Local. </summary>
        public static SqlBackupStorageRedundancy Local { get; } = new SqlBackupStorageRedundancy(LocalValue);
        /// <summary> Zone. </summary>
        public static SqlBackupStorageRedundancy Zone { get; } = new SqlBackupStorageRedundancy(ZoneValue);
        /// <summary> GeoZone. </summary>
        public static SqlBackupStorageRedundancy GeoZone { get; } = new SqlBackupStorageRedundancy(GeoZoneValue);
        /// <summary> Determines if two <see cref="SqlBackupStorageRedundancy"/> values are the same. </summary>
        public static bool operator ==(SqlBackupStorageRedundancy left, SqlBackupStorageRedundancy right) => left.Equals(right);
        /// <summary> Determines if two <see cref="SqlBackupStorageRedundancy"/> values are not the same. </summary>
        public static bool operator !=(SqlBackupStorageRedundancy left, SqlBackupStorageRedundancy right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="SqlBackupStorageRedundancy"/>. </summary>
        public static implicit operator SqlBackupStorageRedundancy(string value) => new SqlBackupStorageRedundancy(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is SqlBackupStorageRedundancy other && Equals(other);
        /// <inheritdoc />
        public bool Equals(SqlBackupStorageRedundancy other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
