// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.Sql.Models
{
    /// <summary> The BackupStorageAccessTier for the LTR backup. </summary>
    public readonly partial struct SqlBackupStorageAccessTier : IEquatable<SqlBackupStorageAccessTier>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="SqlBackupStorageAccessTier"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public SqlBackupStorageAccessTier(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string HotValue = "Hot";
        private const string ArchiveValue = "Archive";

        /// <summary> Hot. </summary>
        public static SqlBackupStorageAccessTier Hot { get; } = new SqlBackupStorageAccessTier(HotValue);
        /// <summary> Archive. </summary>
        public static SqlBackupStorageAccessTier Archive { get; } = new SqlBackupStorageAccessTier(ArchiveValue);
        /// <summary> Determines if two <see cref="SqlBackupStorageAccessTier"/> values are the same. </summary>
        public static bool operator ==(SqlBackupStorageAccessTier left, SqlBackupStorageAccessTier right) => left.Equals(right);
        /// <summary> Determines if two <see cref="SqlBackupStorageAccessTier"/> values are not the same. </summary>
        public static bool operator !=(SqlBackupStorageAccessTier left, SqlBackupStorageAccessTier right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="SqlBackupStorageAccessTier"/>. </summary>
        public static implicit operator SqlBackupStorageAccessTier(string value) => new SqlBackupStorageAccessTier(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is SqlBackupStorageAccessTier other && Equals(other);
        /// <inheritdoc />
        public bool Equals(SqlBackupStorageAccessTier other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
