// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.Sql.Models
{
    /// <summary> Specifies the availability zone the pool's primary replica is pinned to. </summary>
    public readonly partial struct SqlAvailabilityZoneType : IEquatable<SqlAvailabilityZoneType>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="SqlAvailabilityZoneType"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public SqlAvailabilityZoneType(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string NoPreferenceValue = "NoPreference";
        private const string OneValue = "1";
        private const string TwoValue = "2";
        private const string ThreeValue = "3";

        /// <summary> NoPreference. </summary>
        public static SqlAvailabilityZoneType NoPreference { get; } = new SqlAvailabilityZoneType(NoPreferenceValue);
        /// <summary> 1. </summary>
        public static SqlAvailabilityZoneType One { get; } = new SqlAvailabilityZoneType(OneValue);
        /// <summary> 2. </summary>
        public static SqlAvailabilityZoneType Two { get; } = new SqlAvailabilityZoneType(TwoValue);
        /// <summary> 3. </summary>
        public static SqlAvailabilityZoneType Three { get; } = new SqlAvailabilityZoneType(ThreeValue);
        /// <summary> Determines if two <see cref="SqlAvailabilityZoneType"/> values are the same. </summary>
        public static bool operator ==(SqlAvailabilityZoneType left, SqlAvailabilityZoneType right) => left.Equals(right);
        /// <summary> Determines if two <see cref="SqlAvailabilityZoneType"/> values are not the same. </summary>
        public static bool operator !=(SqlAvailabilityZoneType left, SqlAvailabilityZoneType right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="SqlAvailabilityZoneType"/>. </summary>
        public static implicit operator SqlAvailabilityZoneType(string value) => new SqlAvailabilityZoneType(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is SqlAvailabilityZoneType other && Equals(other);
        /// <inheritdoc />
        public bool Equals(SqlAvailabilityZoneType other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
