// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.Sql.Models
{
    /// <summary> Type of enclave requested on the elastic pool. </summary>
    public readonly partial struct SqlAlwaysEncryptedEnclaveType : IEquatable<SqlAlwaysEncryptedEnclaveType>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="SqlAlwaysEncryptedEnclaveType"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public SqlAlwaysEncryptedEnclaveType(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string DefaultValue = "Default";
        private const string VbsValue = "VBS";

        /// <summary> Default. </summary>
        public static SqlAlwaysEncryptedEnclaveType Default { get; } = new SqlAlwaysEncryptedEnclaveType(DefaultValue);
        /// <summary> VBS. </summary>
        public static SqlAlwaysEncryptedEnclaveType Vbs { get; } = new SqlAlwaysEncryptedEnclaveType(VbsValue);
        /// <summary> Determines if two <see cref="SqlAlwaysEncryptedEnclaveType"/> values are the same. </summary>
        public static bool operator ==(SqlAlwaysEncryptedEnclaveType left, SqlAlwaysEncryptedEnclaveType right) => left.Equals(right);
        /// <summary> Determines if two <see cref="SqlAlwaysEncryptedEnclaveType"/> values are not the same. </summary>
        public static bool operator !=(SqlAlwaysEncryptedEnclaveType left, SqlAlwaysEncryptedEnclaveType right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="SqlAlwaysEncryptedEnclaveType"/>. </summary>
        public static implicit operator SqlAlwaysEncryptedEnclaveType(string value) => new SqlAlwaysEncryptedEnclaveType(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is SqlAlwaysEncryptedEnclaveType other && Equals(other);
        /// <inheritdoc />
        public bool Equals(SqlAlwaysEncryptedEnclaveType other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
