// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.Sql.Models
{
    /// <summary> The state of Sql Agent. </summary>
    public readonly partial struct SqlAgentConfigurationPropertiesState : IEquatable<SqlAgentConfigurationPropertiesState>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="SqlAgentConfigurationPropertiesState"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public SqlAgentConfigurationPropertiesState(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string EnabledValue = "Enabled";
        private const string DisabledValue = "Disabled";

        /// <summary> Enabled. </summary>
        public static SqlAgentConfigurationPropertiesState Enabled { get; } = new SqlAgentConfigurationPropertiesState(EnabledValue);
        /// <summary> Disabled. </summary>
        public static SqlAgentConfigurationPropertiesState Disabled { get; } = new SqlAgentConfigurationPropertiesState(DisabledValue);
        /// <summary> Determines if two <see cref="SqlAgentConfigurationPropertiesState"/> values are the same. </summary>
        public static bool operator ==(SqlAgentConfigurationPropertiesState left, SqlAgentConfigurationPropertiesState right) => left.Equals(right);
        /// <summary> Determines if two <see cref="SqlAgentConfigurationPropertiesState"/> values are not the same. </summary>
        public static bool operator !=(SqlAgentConfigurationPropertiesState left, SqlAgentConfigurationPropertiesState right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="SqlAgentConfigurationPropertiesState"/>. </summary>
        public static implicit operator SqlAgentConfigurationPropertiesState(string value) => new SqlAgentConfigurationPropertiesState(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is SqlAgentConfigurationPropertiesState other && Equals(other);
        /// <inheritdoc />
        public bool Equals(SqlAgentConfigurationPropertiesState other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
