// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;

namespace Azure.ResourceManager.Sql.Models
{
    internal static partial class SqlAdvisorStatusExtensions
    {
        public static string ToSerialString(this SqlAdvisorStatus value) => value switch
        {
            SqlAdvisorStatus.GA => "GA",
            SqlAdvisorStatus.PublicPreview => "PublicPreview",
            SqlAdvisorStatus.LimitedPublicPreview => "LimitedPublicPreview",
            SqlAdvisorStatus.PrivatePreview => "PrivatePreview",
            _ => throw new ArgumentOutOfRangeException(nameof(value), value, "Unknown SqlAdvisorStatus value.")
        };

        public static SqlAdvisorStatus ToSqlAdvisorStatus(this string value)
        {
            if (StringComparer.OrdinalIgnoreCase.Equals(value, "GA")) return SqlAdvisorStatus.GA;
            if (StringComparer.OrdinalIgnoreCase.Equals(value, "PublicPreview")) return SqlAdvisorStatus.PublicPreview;
            if (StringComparer.OrdinalIgnoreCase.Equals(value, "LimitedPublicPreview")) return SqlAdvisorStatus.LimitedPublicPreview;
            if (StringComparer.OrdinalIgnoreCase.Equals(value, "PrivatePreview")) return SqlAdvisorStatus.PrivatePreview;
            throw new ArgumentOutOfRangeException(nameof(value), value, "Unknown SqlAdvisorStatus value.");
        }
    }
}
