// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.Sql.Models
{
    /// <summary> Type of the sever administrator. </summary>
    public readonly partial struct SqlAdministratorType : IEquatable<SqlAdministratorType>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="SqlAdministratorType"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public SqlAdministratorType(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string ActiveDirectoryValue = "ActiveDirectory";

        /// <summary> ActiveDirectory. </summary>
        public static SqlAdministratorType ActiveDirectory { get; } = new SqlAdministratorType(ActiveDirectoryValue);
        /// <summary> Determines if two <see cref="SqlAdministratorType"/> values are the same. </summary>
        public static bool operator ==(SqlAdministratorType left, SqlAdministratorType right) => left.Equals(right);
        /// <summary> Determines if two <see cref="SqlAdministratorType"/> values are not the same. </summary>
        public static bool operator !=(SqlAdministratorType left, SqlAdministratorType right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="SqlAdministratorType"/>. </summary>
        public static implicit operator SqlAdministratorType(string value) => new SqlAdministratorType(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is SqlAdministratorType other && Equals(other);
        /// <inheritdoc />
        public bool Equals(SqlAdministratorType other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
