// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.Sql.Models
{
    /// <summary> The SqlAdministratorName. </summary>
    public readonly partial struct SqlAdministratorName : IEquatable<SqlAdministratorName>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="SqlAdministratorName"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public SqlAdministratorName(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string ActiveDirectoryValue = "ActiveDirectory";

        /// <summary> ActiveDirectory. </summary>
        public static SqlAdministratorName ActiveDirectory { get; } = new SqlAdministratorName(ActiveDirectoryValue);
        /// <summary> Determines if two <see cref="SqlAdministratorName"/> values are the same. </summary>
        public static bool operator ==(SqlAdministratorName left, SqlAdministratorName right) => left.Equals(right);
        /// <summary> Determines if two <see cref="SqlAdministratorName"/> values are not the same. </summary>
        public static bool operator !=(SqlAdministratorName left, SqlAdministratorName right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="SqlAdministratorName"/>. </summary>
        public static implicit operator SqlAdministratorName(string value) => new SqlAdministratorName(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is SqlAdministratorName other && Equals(other);
        /// <inheritdoc />
        public bool Equals(SqlAdministratorName other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
