// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;
using Azure.Core;

namespace Azure.ResourceManager.Sql.Models
{
    /// <summary> A server dns alias acquisition request. </summary>
    public partial class ServerDnsAliasAcquisition
    {
        /// <summary>
        /// Keeps track of any properties unknown to the library.
        /// <para>
        /// To assign an object to the value of this property use <see cref="BinaryData.FromObjectAsJson{T}(T, System.Text.Json.JsonSerializerOptions?)"/>.
        /// </para>
        /// <para>
        /// To assign an already formatted json string to this property use <see cref="BinaryData.FromString(string)"/>.
        /// </para>
        /// <para>
        /// Examples:
        /// <list type="bullet">
        /// <item>
        /// <term>BinaryData.FromObjectAsJson("foo")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("\"foo\"")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromObjectAsJson(new { key = "value" })</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("{\"key\": \"value\"}")</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// </list>
        /// </para>
        /// </summary>
        private IDictionary<string, BinaryData> _serializedAdditionalRawData;

        /// <summary> Initializes a new instance of <see cref="ServerDnsAliasAcquisition"/>. </summary>
        /// <param name="oldServerDnsAliasId"> The id of the server alias that will be acquired to point to this server instead. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="oldServerDnsAliasId"/> is null. </exception>
        public ServerDnsAliasAcquisition(ResourceIdentifier oldServerDnsAliasId)
        {
            Argument.AssertNotNull(oldServerDnsAliasId, nameof(oldServerDnsAliasId));

            OldServerDnsAliasId = oldServerDnsAliasId;
        }

        /// <summary> Initializes a new instance of <see cref="ServerDnsAliasAcquisition"/>. </summary>
        /// <param name="oldServerDnsAliasId"> The id of the server alias that will be acquired to point to this server instead. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        internal ServerDnsAliasAcquisition(ResourceIdentifier oldServerDnsAliasId, IDictionary<string, BinaryData> serializedAdditionalRawData)
        {
            OldServerDnsAliasId = oldServerDnsAliasId;
            _serializedAdditionalRawData = serializedAdditionalRawData;
        }

        /// <summary> Initializes a new instance of <see cref="ServerDnsAliasAcquisition"/> for deserialization. </summary>
        internal ServerDnsAliasAcquisition()
        {
        }

        /// <summary> The id of the server alias that will be acquired to point to this server instead. </summary>
        [WirePath("oldServerDnsAliasId")]
        public ResourceIdentifier OldServerDnsAliasId { get; }
    }
}
