// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;

namespace Azure.ResourceManager.Sql.Models
{
    internal static partial class SecurityEventTypeExtensions
    {
        public static string ToSerialString(this SecurityEventType value) => value switch
        {
            SecurityEventType.Undefined => "Undefined",
            SecurityEventType.SqlInjectionVulnerability => "SqlInjectionVulnerability",
            SecurityEventType.SqlInjectionExploit => "SqlInjectionExploit",
            _ => throw new ArgumentOutOfRangeException(nameof(value), value, "Unknown SecurityEventType value.")
        };

        public static SecurityEventType ToSecurityEventType(this string value)
        {
            if (StringComparer.OrdinalIgnoreCase.Equals(value, "Undefined")) return SecurityEventType.Undefined;
            if (StringComparer.OrdinalIgnoreCase.Equals(value, "SqlInjectionVulnerability")) return SecurityEventType.SqlInjectionVulnerability;
            if (StringComparer.OrdinalIgnoreCase.Equals(value, "SqlInjectionExploit")) return SecurityEventType.SqlInjectionExploit;
            throw new ArgumentOutOfRangeException(nameof(value), value, "Unknown SecurityEventType value.");
        }
    }
}
