// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;

namespace Azure.ResourceManager.Sql.Models
{
    internal static partial class SecurityAlertPolicyStateExtensions
    {
        public static string ToSerialString(this SecurityAlertPolicyState value) => value switch
        {
            SecurityAlertPolicyState.New => "New",
            SecurityAlertPolicyState.Enabled => "Enabled",
            SecurityAlertPolicyState.Disabled => "Disabled",
            _ => throw new ArgumentOutOfRangeException(nameof(value), value, "Unknown SecurityAlertPolicyState value.")
        };

        public static SecurityAlertPolicyState ToSecurityAlertPolicyState(this string value)
        {
            if (StringComparer.OrdinalIgnoreCase.Equals(value, "New")) return SecurityAlertPolicyState.New;
            if (StringComparer.OrdinalIgnoreCase.Equals(value, "Enabled")) return SecurityAlertPolicyState.Enabled;
            if (StringComparer.OrdinalIgnoreCase.Equals(value, "Disabled")) return SecurityAlertPolicyState.Disabled;
            throw new ArgumentOutOfRangeException(nameof(value), value, "Unknown SecurityAlertPolicyState value.");
        }
    }
}
