// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.Sql.Models
{
    /// <summary> The secondary type of the database if it is a secondary.  Valid values are Geo, Named and Standby. </summary>
    public readonly partial struct SecondaryType : IEquatable<SecondaryType>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="SecondaryType"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public SecondaryType(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string GeoValue = "Geo";
        private const string NamedValue = "Named";
        private const string StandbyValue = "Standby";

        /// <summary> Geo. </summary>
        public static SecondaryType Geo { get; } = new SecondaryType(GeoValue);
        /// <summary> Named. </summary>
        public static SecondaryType Named { get; } = new SecondaryType(NamedValue);
        /// <summary> Standby. </summary>
        public static SecondaryType Standby { get; } = new SecondaryType(StandbyValue);
        /// <summary> Determines if two <see cref="SecondaryType"/> values are the same. </summary>
        public static bool operator ==(SecondaryType left, SecondaryType right) => left.Equals(right);
        /// <summary> Determines if two <see cref="SecondaryType"/> values are not the same. </summary>
        public static bool operator !=(SecondaryType left, SecondaryType right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="SecondaryType"/>. </summary>
        public static implicit operator SecondaryType(string value) => new SecondaryType(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is SecondaryType other && Equals(other);
        /// <inheritdoc />
        public bool Equals(SecondaryType other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
