// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.Sql.Models
{
    /// <summary> The name of the sample schema to apply when creating this database. </summary>
    public readonly partial struct SampleSchemaName : IEquatable<SampleSchemaName>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="SampleSchemaName"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public SampleSchemaName(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string AdventureWorksLTValue = "AdventureWorksLT";
        private const string WideWorldImportersStdValue = "WideWorldImportersStd";
        private const string WideWorldImportersFullValue = "WideWorldImportersFull";

        /// <summary> AdventureWorksLT. </summary>
        public static SampleSchemaName AdventureWorksLT { get; } = new SampleSchemaName(AdventureWorksLTValue);
        /// <summary> WideWorldImportersStd. </summary>
        public static SampleSchemaName WideWorldImportersStd { get; } = new SampleSchemaName(WideWorldImportersStdValue);
        /// <summary> WideWorldImportersFull. </summary>
        public static SampleSchemaName WideWorldImportersFull { get; } = new SampleSchemaName(WideWorldImportersFullValue);
        /// <summary> Determines if two <see cref="SampleSchemaName"/> values are the same. </summary>
        public static bool operator ==(SampleSchemaName left, SampleSchemaName right) => left.Equals(right);
        /// <summary> Determines if two <see cref="SampleSchemaName"/> values are not the same. </summary>
        public static bool operator !=(SampleSchemaName left, SampleSchemaName right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="SampleSchemaName"/>. </summary>
        public static implicit operator SampleSchemaName(string value) => new SampleSchemaName(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is SampleSchemaName other && Equals(other);
        /// <inheritdoc />
        public bool Equals(SampleSchemaName other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
