// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.Sql.Models
{
    /// <summary> The RestoreDetailsName. </summary>
    public readonly partial struct RestoreDetailsName : IEquatable<RestoreDetailsName>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="RestoreDetailsName"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public RestoreDetailsName(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string DefaultValue = "Default";

        /// <summary> Default. </summary>
        public static RestoreDetailsName Default { get; } = new RestoreDetailsName(DefaultValue);
        /// <summary> Determines if two <see cref="RestoreDetailsName"/> values are the same. </summary>
        public static bool operator ==(RestoreDetailsName left, RestoreDetailsName right) => left.Equals(right);
        /// <summary> Determines if two <see cref="RestoreDetailsName"/> values are not the same. </summary>
        public static bool operator !=(RestoreDetailsName left, RestoreDetailsName right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="RestoreDetailsName"/>. </summary>
        public static implicit operator RestoreDetailsName(string value) => new RestoreDetailsName(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is RestoreDetailsName other && Equals(other);
        /// <inheritdoc />
        public bool Equals(RestoreDetailsName other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
