// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.Sql.Models
{
    /// <summary> Link type (GEO, NAMED, STANDBY). Update operation does not support NAMED. </summary>
    public readonly partial struct ReplicationLinkType : IEquatable<ReplicationLinkType>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="ReplicationLinkType"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public ReplicationLinkType(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string GeoValue = "GEO";
        private const string NamedValue = "NAMED";
        private const string StandbyValue = "STANDBY";

        /// <summary> GEO. </summary>
        public static ReplicationLinkType Geo { get; } = new ReplicationLinkType(GeoValue);
        /// <summary> NAMED. </summary>
        public static ReplicationLinkType Named { get; } = new ReplicationLinkType(NamedValue);
        /// <summary> STANDBY. </summary>
        public static ReplicationLinkType Standby { get; } = new ReplicationLinkType(StandbyValue);
        /// <summary> Determines if two <see cref="ReplicationLinkType"/> values are the same. </summary>
        public static bool operator ==(ReplicationLinkType left, ReplicationLinkType right) => left.Equals(right);
        /// <summary> Determines if two <see cref="ReplicationLinkType"/> values are not the same. </summary>
        public static bool operator !=(ReplicationLinkType left, ReplicationLinkType right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="ReplicationLinkType"/>. </summary>
        public static implicit operator ReplicationLinkType(string value) => new ReplicationLinkType(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is ReplicationLinkType other && Equals(other);
        /// <inheritdoc />
        public bool Equals(ReplicationLinkType other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
