// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.Sql.Models
{
    /// <summary> Replication state (PENDING, SEEDING, CATCHUP, SUSPENDED). </summary>
    public readonly partial struct ReplicationLinkState : IEquatable<ReplicationLinkState>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="ReplicationLinkState"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public ReplicationLinkState(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string PendingValue = "PENDING";
        private const string SeedingValue = "SEEDING";
        private const string CatchUpValue = "CATCH_UP";
        private const string SuspendedValue = "SUSPENDED";

        /// <summary> PENDING. </summary>
        public static ReplicationLinkState Pending { get; } = new ReplicationLinkState(PendingValue);
        /// <summary> SEEDING. </summary>
        public static ReplicationLinkState Seeding { get; } = new ReplicationLinkState(SeedingValue);
        /// <summary> CATCH_UP. </summary>
        public static ReplicationLinkState CatchUp { get; } = new ReplicationLinkState(CatchUpValue);
        /// <summary> SUSPENDED. </summary>
        public static ReplicationLinkState Suspended { get; } = new ReplicationLinkState(SuspendedValue);
        /// <summary> Determines if two <see cref="ReplicationLinkState"/> values are the same. </summary>
        public static bool operator ==(ReplicationLinkState left, ReplicationLinkState right) => left.Equals(right);
        /// <summary> Determines if two <see cref="ReplicationLinkState"/> values are not the same. </summary>
        public static bool operator !=(ReplicationLinkState left, ReplicationLinkState right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="ReplicationLinkState"/>. </summary>
        public static implicit operator ReplicationLinkState(string value) => new ReplicationLinkState(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is ReplicationLinkState other && Equals(other);
        /// <inheritdoc />
        public bool Equals(ReplicationLinkState other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
