// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;

namespace Azure.ResourceManager.Sql.Models
{
    /// <summary> Contains time series of various impacted metrics for an Azure SQL Database, Server or Elastic Pool Recommended Action. </summary>
    public partial class RecommendedActionMetricInfo
    {
        /// <summary>
        /// Keeps track of any properties unknown to the library.
        /// <para>
        /// To assign an object to the value of this property use <see cref="BinaryData.FromObjectAsJson{T}(T, System.Text.Json.JsonSerializerOptions?)"/>.
        /// </para>
        /// <para>
        /// To assign an already formatted json string to this property use <see cref="BinaryData.FromString(string)"/>.
        /// </para>
        /// <para>
        /// Examples:
        /// <list type="bullet">
        /// <item>
        /// <term>BinaryData.FromObjectAsJson("foo")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("\"foo\"")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromObjectAsJson(new { key = "value" })</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("{\"key\": \"value\"}")</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// </list>
        /// </para>
        /// </summary>
        private IDictionary<string, BinaryData> _serializedAdditionalRawData;

        /// <summary> Initializes a new instance of <see cref="RecommendedActionMetricInfo"/>. </summary>
        internal RecommendedActionMetricInfo()
        {
        }

        /// <summary> Initializes a new instance of <see cref="RecommendedActionMetricInfo"/>. </summary>
        /// <param name="metricName"> Gets the name of the metric. e.g., CPU, Number of Queries. </param>
        /// <param name="unit"> Gets the unit in which metric is measured. e.g., DTU, Frequency. </param>
        /// <param name="timeGrain"> Gets the duration of time interval for the value given by this MetricInfo. e.g., PT1H (1 hour). </param>
        /// <param name="startOn"> Gets the start time of time interval given by this MetricInfo. </param>
        /// <param name="value"> Gets the value of the metric in the time interval given by this MetricInfo. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        internal RecommendedActionMetricInfo(string metricName, string unit, string timeGrain, DateTimeOffset? startOn, double? value, IDictionary<string, BinaryData> serializedAdditionalRawData)
        {
            MetricName = metricName;
            Unit = unit;
            TimeGrain = timeGrain;
            StartOn = startOn;
            Value = value;
            _serializedAdditionalRawData = serializedAdditionalRawData;
        }

        /// <summary> Gets the name of the metric. e.g., CPU, Number of Queries. </summary>
        [WirePath("metricName")]
        public string MetricName { get; }
        /// <summary> Gets the unit in which metric is measured. e.g., DTU, Frequency. </summary>
        [WirePath("unit")]
        public string Unit { get; }
        /// <summary> Gets the duration of time interval for the value given by this MetricInfo. e.g., PT1H (1 hour). </summary>
        [WirePath("timeGrain")]
        public string TimeGrain { get; }
        /// <summary> Gets the start time of time interval given by this MetricInfo. </summary>
        [WirePath("startTime")]
        public DateTimeOffset? StartOn { get; }
        /// <summary> Gets the value of the metric in the time interval given by this MetricInfo. </summary>
        [WirePath("value")]
        public double? Value { get; }
    }
}
